/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TryCatchFinally;
import net.sourceforge.stripes.tag.StripesTagSupport;
import org.apache.wiki.WikiContext;
import org.apache.wiki.action.WikiActionBean;
import org.apache.wiki.action.WikiContextFactory;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.ui.stripes.WikiInterceptor;
import org.apache.wiki.util.TextUtil;

public abstract class WikiTagBase
extends StripesTagSupport
implements TryCatchFinally {
    public static final String ATTR_CONTEXT = "wikiContext";
    static Logger log = LoggerFactory.getLogger(WikiTagBase.class);
    protected WikiContext m_wikiContext;
    protected WikiActionBean m_wikiActionBean;
    private String m_id;

    public void setPageContext(PageContext arg0) {
        super.setPageContext(arg0);
        this.initTag();
    }

    public void initTag() {
        this.m_wikiActionBean = null;
        this.m_wikiContext = null;
        this.m_id = null;
    }

    public int doStartTag() throws JspException {
        try {
            this.m_wikiActionBean = WikiInterceptor.findActionBean(this.getPageContext());
            if (this.m_wikiActionBean == null) {
                throw new JspException("Can't find WikiActionBean in page context! (tag=" + ((Object)((Object)this)).getClass() + ")");
            }
            this.m_wikiContext = WikiContextFactory.findContext(this.pageContext);
            if (this.m_wikiContext == null) {
                throw new JspException("WikiContext may not be NULL - serious internal problem!");
            }
            return this.doWikiStartTag();
        }
        catch (Exception e) {
            log.error("Tag failed", e);
            throw new JspException("Tag failed, check logs: " + (e.getMessage() == null ? e : e.getMessage()));
        }
    }

    public abstract int doWikiStartTag() throws Exception;

    public int doEndTag() throws JspException {
        return 6;
    }

    public int doAfterBody() throws JspException {
        return 0;
    }

    public String getId() {
        return this.m_id;
    }

    public void doCatch(Throwable cause) throws Throwable {
        throw cause;
    }

    public void doFinally() {
        this.m_wikiActionBean = null;
        this.m_wikiContext = null;
        this.m_id = null;
    }

    public void setId(String id) {
        this.m_id = TextUtil.replaceEntities(id);
    }
}

