/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.wiki.WikiContext;
import org.apache.wiki.action.WikiContextFactory;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.parser.MarkupParser;
import org.apache.wiki.parser.WikiDocument;
import org.apache.wiki.render.RenderingManager;

public class TranslateTag
extends BodyTagSupport {
    private static final long serialVersionUID = 0L;
    static Logger log = LoggerFactory.getLogger(TranslateTag.class);

    public final int doAfterBody() throws JspException {
        try {
            WikiContext context = WikiContextFactory.findContext(this.pageContext);
            BodyContent bc = this.getBodyContent();
            String wikiText = bc.getString();
            if (wikiText != null) {
                wikiText.trim();
            }
            bc.clearBody();
            if (wikiText != null && wikiText.length() > 0) {
                RenderingManager renderer = context.getEngine().getRenderingManager();
                MarkupParser mp = renderer.getParser(context, wikiText);
                mp.disableAccessRules();
                WikiDocument doc = mp.parse();
                String result = renderer.getHTML(context, doc);
                this.getPreviousOut().write(result);
            }
        }
        catch (Exception e) {
            log.error("Tag failed", e);
            throw new JspException("Tag failed, check logs: " + e.getMessage());
        }
        return 0;
    }
}

