/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import net.sourceforge.stripes.util.UrlBuilder;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.i18n.InternationalizationManager;
import org.apache.wiki.tags.TabTag;

public class TabbedSectionTag
extends BodyTagSupport {
    private static final long serialVersionUID = 2702437933960026481L;
    private WikiEngine m_engine;
    private static final String ATTR_TABS = "JSPWiki.TabbedSection.Tags";
    private String m_defaultTabID = null;

    public static TabCollection getTabContext(ServletRequest request) {
        TabCollection tc = (TabCollection)request.getAttribute(ATTR_TABS);
        if (tc == null) {
            tc = new TabCollection();
            request.setAttribute(ATTR_TABS, (Object)tc);
        }
        return tc;
    }

    public void release() {
        super.release();
        this.m_defaultTabID = null;
    }

    public int doStartTag() throws JspTagException {
        this.m_engine = WikiEngine.getInstance(((HttpServletRequest)this.pageContext.getRequest()).getSession().getServletContext(), null);
        return 2;
    }

    public int doAfterBody() throws JspTagException {
        BodyContent body = this.getBodyContent();
        String bodyString = body.getString();
        TabCollection tc = TabbedSectionTag.getTabContext(this.pageContext.getRequest());
        List<TabTag.Info> tabs = tc.getTabs();
        try {
            body.clear();
            JspWriter writer = this.getPreviousOut();
            writer.append((CharSequence)"<div class=\"tabmenu\">\n");
            for (TabTag.Info tab : tabs) {
                String id = tab.options.get("id");
                if (id.equals(this.m_defaultTabID)) {
                    this.m_defaultTabID = id;
                }
                if (this.m_defaultTabID == null || this.m_defaultTabID.length() == 0) {
                    this.m_defaultTabID = id;
                }
                this.writeTabMenuItem(writer, tab);
            }
            writer.append((CharSequence)"</div>\n");
            writer.append((CharSequence)"<div class=\"tabs\">");
            String activeTabDiv = "<div id=\"" + this.m_defaultTabID + "\" class=\"hidetab\">";
            bodyString = bodyString.replace(activeTabDiv, "<div id=\"" + this.m_defaultTabID + "\">");
            writer.append((CharSequence)bodyString);
            writer.append((CharSequence)"  <div style=\"clear:both;\" ></div>\n</div>\n");
        }
        catch (IOException e) {
            throw new JspTagException((Throwable)e);
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        TabCollection tc = TabbedSectionTag.getTabContext(this.pageContext.getRequest());
        tc.release();
        return super.doEndTag();
    }

    private void writeTabMenuItem(JspWriter writer, TabTag.Info tab) throws IOException {
        writer.append((CharSequence)"  <a");
        String id = tab.options.get("id");
        writer.append((CharSequence)(" id=\"menu-" + id + "\""));
        if (id.equals(this.m_defaultTabID)) {
            writer.append((CharSequence)" class=\"activetab\"");
        }
        if (tab.options.get("onClick") != null) {
            writer.append((CharSequence)(" onclick=\"" + tab.options.get("onClick") + "\""));
        }
        if (tab.beanclass != null) {
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            UrlBuilder builder = new UrlBuilder(request.getLocale(), tab.beanclass, true);
            if (tab.options.get("event") != null) {
                builder.setEvent(tab.options.get("event"));
            }
            for (Map.Entry<String, String> entry : tab.containedParams.entrySet()) {
                builder.addParameter(entry.getKey(), new Object[]{entry.getValue()});
            }
            String url = builder.toString();
            if (request.getContextPath() != null && !url.startsWith(request.getContextPath())) {
                url = String.valueOf(request.getContextPath()) + url;
            }
            writer.append((CharSequence)(" href='" + url + "'"));
        } else if (tab.options.get("url") != null) {
            writer.append((CharSequence)(" href='" + tab.options.get("url") + "'"));
        }
        String tabTitle = null;
        if (tab.options.get("tabTitleKey") != null) {
            Locale locale = this.pageContext.getRequest().getLocale();
            InternationalizationManager i18n = this.m_engine.getInternationalizationManager();
            tabTitle = i18n.get("templates.default", locale, tab.options.get("tabTitleKey"));
        }
        if (tabTitle == null) {
            tabTitle = tab.options.get("tabTitle");
        }
        writer.append((CharSequence)">");
        String accesskey = tab.options.get("accessKey");
        if (tabTitle != null) {
            int pos;
            if (accesskey != null && (pos = tabTitle.toLowerCase().indexOf(accesskey.toLowerCase())) > -1) {
                tabTitle = String.valueOf(tabTitle.substring(0, pos)) + "<span class='accesskey'>" + tabTitle.charAt(pos) + "</span>" + tabTitle.substring(pos + 1);
            }
            writer.append((CharSequence)tabTitle);
        }
        writer.append((CharSequence)"</a>\n");
    }

    protected String getDefaultTab() {
        return this.m_defaultTabID;
    }

    public void setDefaultTab(String defaultTab) {
        this.m_defaultTabID = defaultTab;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TabCollection {
        private final List<TabTag.Info> m_tabs = new ArrayList<TabTag.Info>();

        private TabCollection() {
        }

        public void addTab(TabTag tab) throws JspTagException {
            if (tab == null) {
                throw new JspTagException("Cannot add null TabTag.");
            }
            this.m_tabs.add((TabTag.Info)tab.getTabInfo().clone());
        }

        public List<TabTag.Info> getTabs() {
            return this.m_tabs;
        }

        public void release() {
            this.m_tabs.clear();
        }
    }
}

