/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.JspTagException;
import net.sourceforge.stripes.action.ActionBean;
import org.apache.wiki.tags.ParamHandler;
import org.apache.wiki.tags.TabbedSectionTag;
import org.apache.wiki.tags.WikiTagBase;
import org.apache.wiki.util.TextUtil;

public class TabTag
extends WikiTagBase
implements ParamHandler {
    private static final long serialVersionUID = -8534125226484616489L;
    private final Info m_info = new Info();

    protected Info getTabInfo() {
        return this.m_info;
    }

    public int doEndTag() throws JspTagException {
        TabbedSectionTag.TabCollection tc = TabbedSectionTag.getTabContext(this.getPageContext().getRequest());
        tc.addTab(this);
        try {
            this.pageContext.getOut().write("</div>\n");
        }
        catch (IOException e) {
            throw new JspTagException("IO Error: " + e.getMessage());
        }
        return 6;
    }

    public void doFinally() {
        super.doFinally();
        this.m_info.beanclass = null;
        this.m_info.containedParams.clear();
        this.m_info.options.clear();
    }

    public int doWikiStartTag() throws JspTagException, ClassNotFoundException {
        if (this.getId() == null) {
            throw new JspTagException("Tab Tag without \"id\" attribute");
        }
        if (this.m_info.options.get("tabTitle") == null && this.m_info.options.get("tabTitleKey") == null) {
            throw new JspTagException("Tab Tag without \"tabTitle\" or \"tabTitleKey\" attribute");
        }
        try {
            this.pageContext.getOut().write("<div id=\"");
            this.pageContext.getOut().write(this.getId());
            this.pageContext.getOut().write("\" class=\"hidetab\">\n");
        }
        catch (IOException e) {
            throw new JspTagException("IO Error: " + e.getMessage());
        }
        return 1;
    }

    public void setId(String id) {
        super.setId(id);
        this.m_info.options.put("id", id);
    }

    public void setAccesskey(String accessKey) {
        if (accessKey != null && accessKey.length() > 0) {
            this.m_info.options.put("accessKey", accessKey.substring(0, 1));
        }
    }

    public void setBeanclass(String beanclass) throws ClassNotFoundException {
        this.m_info.beanclass = Class.forName(beanclass);
    }

    public void setContainedParameter(String name, String value) {
        this.m_info.containedParams.put(name, value);
    }

    public void setEvent(String event) {
        this.m_info.options.put("event", TextUtil.replaceEntities(event));
    }

    public void setOnclick(String onclick) {
        this.m_info.options.put("onClick", onclick);
    }

    public void setTitle(String title) {
        this.m_info.options.put("tabTitle", TextUtil.replaceEntities(title));
    }

    public void setTitleKey(String key) {
        this.m_info.options.put("tabTitleKey", TextUtil.replaceEntities(key));
    }

    public void setUrl(String url) {
        this.m_info.options.put("url", TextUtil.replaceEntities(url));
    }

    public static class Info
    implements Cloneable {
        static final String ACCESS_KEY = "accessKey";
        static final String EVENT = "event";
        static final String ID = "id";
        static final String ON_CLICK = "onClick";
        static final String TITLE = "tabTitle";
        static final String TITLE_KEY = "tabTitleKey";
        static final String URL = "url";
        Class<? extends ActionBean> beanclass = null;
        final Map<String, String> containedParams = new HashMap<String, String>();
        final Map<String, String> options = new HashMap<String, String>();

        public Object clone() {
            Info info = new Info();
            if (this.beanclass != null) {
                info.beanclass = this.beanclass;
            }
            info.containedParams.putAll(this.containedParams);
            info.options.putAll(this.options);
            return info;
        }
    }
}

