/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.List;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import net.sourceforge.stripes.util.CryptoUtil;
import net.sourceforge.stripes.validation.LocalizableError;
import net.sourceforge.stripes.validation.ValidationError;
import net.sourceforge.stripes.validation.ValidationErrors;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.WikiException;
import org.apache.wiki.content.inspect.Captcha;
import org.apache.wiki.content.inspect.Challenge;
import org.apache.wiki.content.inspect.PasswordChallenge;
import org.apache.wiki.content.inspect.SpamInspectionPlan;
import org.apache.wiki.tags.WikiTagBase;
import org.apache.wiki.ui.stripes.WikiActionBeanContext;

public class SpamProtectTag
extends WikiTagBase {
    private Challenge.State m_challenge = Challenge.State.CHALLENGE_NOT_PRESENTED;
    private static final String CHALLENGE_PASSWORD = "password";
    private static final String CHALLENGE_CAPTCHA = "captcha";
    private static final Random RANDOM = new SecureRandom();
    private static final Challenge PASSWORD_CHALLENGE = new PasswordChallenge();

    public int doEndTag() throws JspException {
        try {
            this.writeChallengeFormContent();
            this.writeSpamParams();
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        catch (WikiException e) {
            throw new JspException((Throwable)e);
        }
        return super.doEndTag();
    }

    public int doWikiStartTag() throws Exception {
        return 0;
    }

    public void setChallenge(String challenge) {
        if (CHALLENGE_CAPTCHA.equals(challenge.toLowerCase())) {
            this.m_challenge = Challenge.State.CAPTCHA_PRESENTED;
        } else if (CHALLENGE_PASSWORD.equals(challenge.toLowerCase())) {
            if (!this.m_wikiContext.getEngine().getAuthenticationManager().isContainerAuthenticated()) {
                this.m_challenge = Challenge.State.PASSWORD_PRESENTED;
            }
        } else {
            this.m_challenge = Challenge.State.CHALLENGE_NOT_PRESENTED;
        }
    }

    private String getUniqueID() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < 6) {
            char x = (char)(65 + RANDOM.nextInt(26));
            sb.append(x);
            ++i;
        }
        return sb.toString();
    }

    public static boolean isSpamDetected(WikiActionBeanContext actionBeanContext) {
        ValidationErrors errors = actionBeanContext.getValidationErrors();
        if (errors.containsKey((Object)"__stripes_global_error")) {
            for (ValidationError error : (List)errors.get((Object)"__stripes_global_error")) {
                LocalizableError localError;
                if (!(error instanceof LocalizableError) || !"validation.challenge.required".equals((localError = (LocalizableError)error).getMessageKey())) continue;
                return true;
            }
        }
        return false;
    }

    private void writeChallengeFormContent() throws IOException, WikiException {
        WikiEngine engine = this.m_wikiContext.getEngine();
        SpamInspectionPlan plan = SpamInspectionPlan.getInspectionPlan(engine);
        WikiActionBeanContext actionBeanContext = this.m_wikiActionBean.getContext();
        String challengeContent = null;
        boolean writeCaptcha = false;
        switch (this.m_challenge) {
            case PASSWORD_PRESENTED: {
                challengeContent = PASSWORD_CHALLENGE.formContent(actionBeanContext);
                break;
            }
            case CAPTCHA_PRESENTED: {
                writeCaptcha = true;
                break;
            }
            case CHALLENGE_NOT_PRESENTED: {
                if (!SpamProtectTag.isSpamDetected(actionBeanContext)) break;
                this.m_challenge = Challenge.State.CAPTCHA_PRESENTED;
                writeCaptcha = true;
            }
        }
        Captcha captcha = plan.getCaptcha();
        if (writeCaptcha) {
            if (captcha.isEnabled()) {
                challengeContent = captcha.formContent(actionBeanContext);
            } else {
                this.m_challenge = Challenge.State.CHALLENGE_NOT_PRESENTED;
            }
        }
        JspWriter out = this.getPageContext().getOut();
        out.write("<input name=\"_cn\" type=\"hidden\" value=\"" + CryptoUtil.encrypt((String)String.valueOf(this.m_challenge.name())) + "\" />\n");
        if (challengeContent != null) {
            out.write(challengeContent);
        }
    }

    private void writeSpamParams() throws IOException {
        JspWriter out = this.pageContext.getOut();
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        String trapParam = "submit_auth";
        out.write("<div style=\"display: none;\">");
        out.write("<input type=\"hidden\" name=\"");
        out.write(trapParam);
        out.write("\" value=\"\" /></div>\n");
        String tokenParam = this.getUniqueID();
        String tokenValue = request.getSession().getId();
        out.write("<input name=\"" + tokenParam + "\" type=\"hidden\" value=\"" + tokenValue + "\" />\n");
        out.write("<input name=\"__wikiEncodingcheck\" type=\"hidden\" value=\"\u3041\" />\n");
        String encryptedParam = CryptoUtil.encrypt((String)tokenParam);
        out.write("<input name=\"__wikiCheck\" type=\"hidden\" value=\"" + encryptedParam + "\" />\n");
    }
}

