/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiSession;
import org.apache.wiki.action.GroupActionBean;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.auth.AuthorizationManager;
import org.apache.wiki.auth.authorize.Group;
import org.apache.wiki.auth.permissions.AllPermission;
import org.apache.wiki.auth.permissions.GroupPermission;
import org.apache.wiki.auth.permissions.PagePermission;
import org.apache.wiki.auth.permissions.PermissionFactory;
import org.apache.wiki.auth.permissions.WikiPermission;
import org.apache.wiki.tags.WikiTagBase;

public class PermissionTag
extends WikiTagBase {
    private static final String ALL_PERMISSION = "allPermission";
    private static final String CREATE_GROUPS = "createGroups";
    private static final String CREATE_PAGES = "createPages";
    private static final String DELETE_GROUP = "deleteGroup";
    private static final String EDIT = "edit";
    private static final String EDIT_GROUP = "editGroup";
    private static final String EDIT_PREFERENCES = "editPreferences";
    private static final String EDIT_PROFILE = "editProfile";
    private static final String LOGIN = "login";
    private static final String VIEW_GROUP = "viewGroup";
    private static final long serialVersionUID = 3761412993048982325L;
    private String[] m_permissionList;

    public void initTag() {
        super.initTag();
        this.m_permissionList = null;
    }

    public void setPermission(String permission) {
        this.m_permissionList = StringUtils.split((String)permission, (char)'|');
    }

    private boolean checkPermission(String permission) {
        WikiSession session = this.m_wikiContext.getWikiSession();
        WikiPage page = this.m_wikiContext.getPage();
        AuthorizationManager mgr = this.m_wikiContext.getEngine().getAuthorizationManager();
        boolean gotPermission = false;
        if (CREATE_GROUPS.equals(permission) || CREATE_PAGES.equals(permission) || EDIT_PREFERENCES.equals(permission) || EDIT_PROFILE.equals(permission) || LOGIN.equals(permission)) {
            gotPermission = mgr.checkPermission(session, new WikiPermission("*", permission));
        } else if (VIEW_GROUP.equals(permission)) {
            Group group = ((GroupActionBean)this.m_wikiActionBean).getGroup();
            GroupPermission perm = new GroupPermission(group.getName(), "view");
            gotPermission = mgr.checkPermission(session, perm);
        } else if (EDIT_GROUP.equals(permission)) {
            Group group = ((GroupActionBean)this.m_wikiActionBean).getGroup();
            GroupPermission perm = new GroupPermission(group.getName(), EDIT);
            gotPermission = mgr.checkPermission(session, perm);
        } else if (DELETE_GROUP.equals(permission)) {
            Group group = ((GroupActionBean)this.m_wikiActionBean).getGroup();
            GroupPermission perm = new GroupPermission(group.getName(), "delete");
            gotPermission = mgr.checkPermission(session, perm);
        } else if (ALL_PERMISSION.equals(permission)) {
            gotPermission = mgr.checkPermission(session, new AllPermission(this.m_wikiContext.getEngine().getApplicationName()));
        } else if (page != null) {
            if (EDIT.equals(permission)) {
                try {
                    WikiEngine engine = this.m_wikiContext.getEngine();
                    if (engine.pageExists(page)) {
                        WikiPage latest = engine.getPage(page.getName());
                        if (page.getVersion() != -1 && latest.getVersion() != page.getVersion()) {
                            return false;
                        }
                    }
                }
                catch (Exception e) {
                    log.error("Failed to find latest version", e);
                    return false;
                }
            }
            PagePermission p = PermissionFactory.getPagePermission(page, permission);
            gotPermission = mgr.checkPermission(session, p);
        }
        return gotPermission;
    }

    public final int doWikiStartTag() throws IOException {
        int i = 0;
        while (i < this.m_permissionList.length) {
            String perm = this.m_permissionList[i];
            boolean hasPermission = false;
            hasPermission = perm.charAt(0) == '!' ? !this.checkPermission(perm.substring(1)) : this.checkPermission(perm);
            if (hasPermission) {
                return 1;
            }
            ++i;
        }
        return 0;
    }
}

