/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import javax.servlet.jsp.JspWriter;
import org.apache.wiki.WikiContext;
import org.apache.wiki.api.WikiException;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.content.PageNotFoundException;
import org.apache.wiki.tags.WikiLinkTag;

public class LinkToTag
extends WikiLinkTag {
    private static final long serialVersionUID = 0L;
    private String m_version = null;
    public String m_title = "";
    public String m_accesskey = "";

    public void initTag() {
        super.initTag();
        this.m_version = null;
    }

    public String getVersion() {
        return this.m_version;
    }

    public void setVersion(String arg) {
        this.m_version = arg;
    }

    public void setTitle(String title) {
        this.m_title = title;
    }

    public void setAccesskey(String access) {
        this.m_accesskey = access;
    }

    public int doWikiStartTag() throws IOException, PageNotFoundException, WikiException {
        String linkclass;
        String url;
        String pageName = this.m_pageName;
        boolean isattachment = false;
        if (this.m_pageName == null) {
            WikiPage p = this.m_wikiContext.getPage();
            if (p != null) {
                pageName = p.getName();
                isattachment = p.isAttachment();
            } else {
                return 0;
            }
        }
        JspWriter out = this.pageContext.getOut();
        if (isattachment) {
            url = this.m_wikiContext.getURL(WikiContext.ATTACH, pageName, this.getVersion() != null ? "version=" + this.getVersion() : null);
            linkclass = "attachment";
        } else {
            StringBuilder params = new StringBuilder();
            if (this.getVersion() != null) {
                params.append("version=" + this.getVersion());
            }
            if (this.getTemplate() != null) {
                params.append(String.valueOf(params.length() > 0 ? "&amp;" : "") + "skin=" + this.getTemplate());
            }
            url = this.m_wikiContext.getURL(WikiContext.VIEW, pageName, params.toString());
            linkclass = "wikipage";
        }
        switch (this.m_format) {
            case 0: {
                out.print("<a class=\"" + linkclass + "\" href=\"" + url + "\" accesskey=\"" + this.m_accesskey + "\" title=\"" + this.m_title + "\">");
                break;
            }
            case 1: {
                out.print(url);
            }
        }
        return 1;
    }
}

