/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.wiki.api.WikiPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JspFunctions {
    public static String getAttachmentsTitle(Locale locale, Collection<WikiPage> attachments) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            ResourceBundle b = ResourceBundle.getBundle("templates.default", locale);
            String key = null;
            switch (attachments.size()) {
                case 0: {
                    key = "attachments.zero";
                    break;
                }
                case 1: {
                    key = "attachments.one";
                    break;
                }
                default: {
                    key = "attachments.many";
                }
            }
            String message = b.getString(key);
            return MessageFormat.format(message, attachments.size());
        }
        catch (MissingResourceException missingResourceException) {
            return "???CORE_BUNDLE missing???";
        }
    }

    public static String getISO8601Date(Date date) {
        if (date == null) {
            return "";
        }
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").format(date);
    }

    public static String shortenedString(String string, int length) {
        if (string == null) {
            return "";
        }
        return string.length() <= length ? string : String.valueOf(string.substring(0, length)) + "...";
    }
}

