/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.TryCatchFinally;
import org.apache.wiki.WikiContext;
import org.apache.wiki.action.WikiContextFactory;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IteratorTag<T>
extends BodyTagSupport
implements TryCatchFinally {
    private static final long serialVersionUID = 7401852034172736286L;
    private static Logger log = LoggerFactory.getLogger(IteratorTag.class);
    private Collection<T> m_items = null;
    private WikiContext m_originalContext = null;
    private int m_maxItems = Integer.MAX_VALUE;
    private int m_count = 0;
    private int m_start = 0;
    private Iterator<T> m_iterator = null;
    protected WikiContext m_wikiContext = null;

    public final int doAfterBody() {
        if (this.bodyContent != null) {
            try {
                JspWriter out = this.getPreviousOut();
                out.print(this.bodyContent.getString());
                this.bodyContent.clearBody();
            }
            catch (IOException e) {
                log.error("Unable to get inner tag text", e);
            }
        }
        if (this.m_iterator.hasNext() && this.m_count++ < this.m_maxItems) {
            T item = this.m_iterator.next();
            this.pageContext.setAttribute(this.getId(), item);
            this.nextItem(item);
            return 2;
        }
        return 0;
    }

    public final void doCatch(Throwable t) throws Throwable {
    }

    public final int doEndTag() {
        return 6;
    }

    public final void doFinally() {
        if (!this.m_iterator.hasNext()) {
            WikiContextFactory.saveContext(this.pageContext.getRequest(), this.m_originalContext);
            this.m_maxItems = Integer.MAX_VALUE;
            this.m_start = 0;
            this.m_count = 0;
            this.m_items = null;
            this.m_iterator = null;
            this.m_wikiContext = null;
            this.m_originalContext = null;
        }
    }

    public final int doStartTag() {
        this.m_wikiContext = WikiContextFactory.findContext(this.pageContext);
        if (this.m_originalContext == null) {
            this.m_originalContext = this.m_wikiContext;
            this.m_wikiContext = (WikiContext)this.m_wikiContext.clone();
            WikiContextFactory.saveContext(this.pageContext.getRequest(), this.m_wikiContext);
        }
        if (this.m_items == null) {
            this.setList(this.initItems());
        }
        this.resetIterator();
        if (this.m_items == null || this.m_items.size() == 0) {
            return 0;
        }
        int skip = 0;
        while (this.m_iterator.hasNext() && skip++ < this.m_start) {
            this.m_iterator.next();
        }
        this.m_count = 0;
        if (this.m_iterator.hasNext() && this.m_count++ < this.m_maxItems) {
            T item = this.m_iterator.next();
            this.pageContext.setAttribute(this.getId(), item);
            this.nextItem(item);
        }
        return 2;
    }

    public void release() {
        super.release();
    }

    public final void resetIterator() {
    }

    public final void setList(Collection<T> items) {
        if (items != null) {
            this.m_items = items;
            this.m_iterator = items.iterator();
        }
    }

    public final void setList(T[] items) {
        if (items != null) {
            this.m_items = Arrays.asList(items);
            this.m_iterator = this.m_items.iterator();
        }
    }

    public void setMaxItems(int maxItems) {
        this.m_maxItems = maxItems;
    }

    public void setStart(int start) {
        this.m_start = start;
    }

    protected Collection<T> initItems() {
        return new ArrayList();
    }

    protected void nextItem(T item) {
        if (item instanceof WikiPage) {
            this.m_wikiContext.setPage((WikiPage)item);
        }
    }
}

