/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import javax.servlet.jsp.JspWriter;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.content.PageNotFoundException;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.tags.WikiTagBase;

public class InsertPageTag
extends WikiTagBase {
    private static final long serialVersionUID = 0L;
    public static final int HTML = 0;
    public static final int PLAIN = 1;
    protected String m_pageName = null;
    private int m_mode = 0;

    public void initTag() {
        super.initTag();
        this.m_pageName = null;
        this.m_mode = 0;
    }

    public void setPage(String page) {
        this.m_pageName = page;
    }

    public String getPage() {
        return this.m_pageName;
    }

    public void setMode(String arg) {
        this.m_mode = "plain".equals(arg) ? 1 : 0;
    }

    public final int doWikiStartTag() throws IOException, ProviderException {
        WikiEngine engine = this.m_wikiContext.getEngine();
        WikiPage insertedPage = null;
        try {
            insertedPage = this.m_pageName == null ? this.m_wikiContext.getPage() : engine.getPage(this.m_pageName);
        }
        catch (PageNotFoundException pageNotFoundException) {
            // empty catch block
        }
        if (insertedPage == null) {
            return 0;
        }
        log.debug("Inserting page " + insertedPage, new Object[0]);
        JspWriter out = this.pageContext.getOut();
        WikiPage oldPage = this.m_wikiContext.setRealPage(insertedPage);
        switch (this.m_mode) {
            case 0: {
                out.print(engine.getHTML(this.m_wikiContext, insertedPage));
                break;
            }
            case 1: {
                out.print(engine.getText(this.m_wikiContext, insertedPage));
            }
        }
        this.m_wikiContext.setRealPage(oldPage);
        return 0;
    }
}

