/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import javax.servlet.jsp.JspWriter;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.action.DiffActionBean;
import org.apache.wiki.api.WikiException;
import org.apache.wiki.content.PageNotFoundException;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.tags.WikiTagBase;

public class InsertDiffTag
extends WikiTagBase {
    private static final long serialVersionUID = 0L;
    public static final String ATTR_OLDVERSION = "olddiff";
    public static final String ATTR_NEWVERSION = "newdiff";
    protected String m_pageName;

    public void initTag() {
        super.initTag();
        this.m_pageName = null;
    }

    public void setPage(String page) {
        this.m_pageName = page;
    }

    public String getPage() {
        return this.m_pageName;
    }

    public final int doWikiStartTag() throws IOException, WikiException {
        WikiContext ctx;
        if (this.m_wikiActionBean == null || !(this.m_wikiActionBean instanceof DiffActionBean)) {
            throw new WikiException("No DiffActionBean found!");
        }
        int vernew = ((DiffActionBean)this.m_wikiActionBean).getR2();
        int verold = ((DiffActionBean)this.m_wikiActionBean).getR1();
        WikiEngine engine = this.m_wikiContext.getEngine();
        if (this.m_pageName == null) {
            ctx = this.m_wikiContext;
        } else {
            try {
                ctx = (WikiContext)this.m_wikiContext.clone();
                ctx.setPage(engine.getPage(this.m_pageName));
            }
            catch (PageNotFoundException e) {
                return 0;
            }
            catch (ProviderException e) {
                throw new IOException("Unable to get page " + e.getMessage());
            }
        }
        log.info("Request diff between version " + verold + " and " + vernew, new Object[0]);
        if (ctx.getPage() != null) {
            JspWriter out = this.pageContext.getOut();
            String diff = engine.getDiff(ctx, vernew, verold);
            if (diff.length() == 0) {
                return 1;
            }
            out.write(diff);
        }
        return 0;
    }
}

