/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspException;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.tags.WikiTagBase;
import org.apache.wiki.ui.TemplateManager;
import org.apache.wiki.util.TextUtil;

public class IncludeTag
extends WikiTagBase {
    private static final long serialVersionUID = 0L;
    protected String m_page;

    public void initTag() {
        super.initTag();
        this.m_page = null;
    }

    public void setPage(String page) {
        this.m_page = page;
    }

    public String getPage() {
        return this.m_page;
    }

    public final int doWikiStartTag() throws IOException, ProviderException {
        return 0;
    }

    public final int doEndTag() throws JspException {
        try {
            String page = TemplateManager.getResourceResolver(this.pageContext.getServletContext()).get(this.m_page);
            if (page == null) {
                this.pageContext.getOut().println("No template file called '" + TextUtil.replaceEntities(this.m_page) + "'");
            } else {
                this.pageContext.include(page);
            }
        }
        catch (ServletException e) {
            log.warn("Including failed, got a servlet exception from sub-page. Rethrowing the exception to the JSP engine.", e, new Object[0]);
            throw new JspException(e.getMessage());
        }
        catch (IOException e) {
            log.warn("I/O exception - probably the connection was broken. Rethrowing the exception to the JSP engine.", e, new Object[0]);
            throw new JspException(e.getMessage());
        }
        return 6;
    }
}

