/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.content.PageNotFoundException;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.tags.IteratorTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryIteratorTag
extends IteratorTag<WikiPage> {
    private static final long serialVersionUID = 1L;
    private static final Collection<WikiPage> EMPTY_COLLECTION = Collections.unmodifiableCollection(new ArrayList());
    private static final Logger log = LoggerFactory.getLogger(HistoryIteratorTag.class);

    @Override
    protected Collection<WikiPage> initItems() {
        WikiPage page = this.m_wikiContext.getPage();
        WikiEngine engine = this.m_wikiContext.getEngine();
        try {
            if (page != null && engine.pageExists(page)) {
                return engine.getVersionHistory(page.getName());
            }
        }
        catch (PageNotFoundException e) {
            log.error("Provider claims page " + page.getName() + " doesn't exist, right after it said it did. This is odd!", e);
        }
        catch (ProviderException e) {
            log.error("Provider failed while trying to fetch history for page " + page.getName(), e);
        }
        return EMPTY_COLLECTION;
    }
}

