/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import javax.servlet.jsp.JspWriter;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.content.PageNotFoundException;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.tags.WikiLinkTag;

public class DiffLinkTag
extends WikiLinkTag {
    private static final long serialVersionUID = 0L;
    public static final String VER_LATEST = "latest";
    public static final String VER_PREVIOUS = "previous";
    public static final String VER_CURRENT = "current";
    private String m_version = "latest";
    private String m_newVersion = "latest";

    public void initTag() {
        super.initTag();
        this.m_newVersion = VER_LATEST;
        this.m_version = VER_LATEST;
    }

    public final String getVersion() {
        return this.m_version;
    }

    public void setVersion(String arg) {
        this.m_version = arg;
    }

    public final String getNewVersion() {
        return this.m_newVersion;
    }

    public void setNewVersion(String arg) {
        this.m_newVersion = arg;
    }

    public final int doWikiStartTag() throws IOException {
        WikiEngine engine = this.m_wikiContext.getEngine();
        String pageName = this.m_pageName;
        if (this.m_pageName == null) {
            if (this.m_wikiContext.getPage() != null) {
                pageName = this.m_wikiContext.getPage().getName();
            } else {
                return 0;
            }
        }
        JspWriter out = this.pageContext.getOut();
        int r1 = 0;
        int r2 = 0;
        if (!engine.pageExists(pageName)) {
            return 0;
        }
        try {
            WikiPage latest;
            if (VER_LATEST.equals(this.getVersion())) {
                latest = engine.getPage(pageName, -1);
                r1 = latest.getVersion();
            } else {
                r1 = VER_PREVIOUS.equals(this.getVersion()) ? ((r1 = this.m_wikiContext.getPage().getVersion() - 1) < 1 ? 1 : r1) : (VER_CURRENT.equals(this.getVersion()) ? this.m_wikiContext.getPage().getVersion() : Integer.parseInt(this.getVersion()));
            }
            if (VER_LATEST.equals(this.getNewVersion())) {
                latest = engine.getPage(pageName, -1);
                r2 = latest.getVersion();
            } else {
                r2 = VER_PREVIOUS.equals(this.getNewVersion()) ? ((r2 = this.m_wikiContext.getPage().getVersion() - 1) < 1 ? 1 : r2) : (VER_CURRENT.equals(this.getNewVersion()) ? this.m_wikiContext.getPage().getVersion() : Integer.parseInt(this.getNewVersion()));
            }
        }
        catch (PageNotFoundException e) {
            return 0;
        }
        catch (ProviderException e) {
            log.error("Unable to get page data", e);
            return 0;
        }
        String url = this.m_wikiContext.getURL(WikiContext.DIFF, pageName, "r1=" + r1 + "&amp;r2=" + r2);
        switch (this.m_format) {
            case 0: {
                out.print("<a href=\"" + url + "\">");
                break;
            }
            case 1: {
                out.print(url);
            }
        }
        return 1;
    }
}

