/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspException;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.tags.WikiTagBase;
import org.apache.wiki.ui.TemplateManager;

public class ContentTag
extends WikiTagBase {
    private static final long serialVersionUID = 0L;
    private Map<String, String> m_mappings = new HashMap<String, String>();

    public void setView(String s) {
        this.m_mappings.put(WikiContext.VIEW, s);
    }

    public void setDiff(String s) {
        this.m_mappings.put(WikiContext.DIFF, s);
    }

    public void setInfo(String s) {
        this.m_mappings.put(WikiContext.INFO, s);
    }

    public void setPreview(String s) {
        this.m_mappings.put(WikiContext.PREVIEW, s);
    }

    public void setConflict(String s) {
        this.m_mappings.put(WikiContext.CONFLICT, s);
    }

    public void setFind(String s) {
        this.m_mappings.put(WikiContext.FIND, s);
    }

    public void setPrefs(String s) {
        this.m_mappings.put(WikiContext.PREFS, s);
    }

    public void setError(String s) {
        this.m_mappings.put(WikiContext.ERROR, s);
    }

    public void setEdit(String s) {
        this.m_mappings.put("edit", s);
    }

    public void setComment(String s) {
        this.m_mappings.put(WikiContext.COMMENT, s);
    }

    public final int doWikiStartTag() throws IOException, ProviderException {
        return 0;
    }

    public final int doEndTag() throws JspException {
        try {
            String requestContext = this.m_wikiContext.getRequestContext();
            String contentTemplate = this.m_mappings.get(requestContext);
            WikiEngine engine = this.m_wikiContext.getEngine();
            contentTemplate = engine.getVariable(this.m_wikiContext, "contentTemplate");
            if (contentTemplate == null) {
                String beanName = this.m_wikiActionBean.getClass().getSimpleName();
                if (beanName.endsWith("ActionBean")) {
                    beanName = beanName.substring(0, beanName.lastIndexOf("ActionBean"));
                }
                contentTemplate = String.valueOf(beanName) + "Content.jsp";
            }
            String page = TemplateManager.getResourceResolver(this.pageContext.getServletContext()).get(contentTemplate);
            this.pageContext.include(page);
        }
        catch (ServletException e) {
            log.warn("Including failed, got a servlet exception from sub-page. Rethrowing the exception to the JSP engine.", e, new Object[0]);
            throw new JspException(e.getMessage());
        }
        catch (IOException e) {
            log.warn("I/O exception - probably the connection was broken. Rethrowing the exception to the JSP engine.", e, new Object[0]);
            throw new JspException(e.getMessage());
        }
        return 6;
    }
}

