/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspWriter;
import org.apache.wiki.WikiContext;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.tags.WikiTagBase;

public class BreadcrumbsTag
extends WikiTagBase {
    private static final long serialVersionUID = 0L;
    private static final Logger log = LoggerFactory.getLogger(BreadcrumbsTag.class);
    public static final String BREADCRUMBTRAIL_KEY = "breadCrumbTrail";
    private int m_maxQueueSize = 11;
    private String m_separator = ", ";

    public void initTag() {
        super.initTag();
        this.m_maxQueueSize = 11;
        this.m_separator = ", ";
    }

    public int getMaxpages() {
        return this.m_maxQueueSize;
    }

    public void setMaxpages(int maxpages) {
        this.m_maxQueueSize = maxpages + 1;
    }

    public String getSeparator() {
        return this.m_separator;
    }

    public void setSeparator(String separator) {
        this.m_separator = separator;
    }

    public int doWikiStartTag() throws IOException {
        HttpSession session = this.pageContext.getSession();
        FixedQueue trail = (FixedQueue)session.getAttribute(BREADCRUMBTRAIL_KEY);
        if (trail == null) {
            trail = new FixedQueue(this.m_maxQueueSize);
        }
        if (this.m_wikiContext.getRequestContext().equals(WikiContext.VIEW)) {
            String page = this.m_wikiContext.getPage().getName();
            if (this.m_wikiContext.getEngine().pageExists(page)) {
                if (trail.isEmpty()) {
                    trail.pushItem(page);
                } else {
                    if (!((String)trail.getLast()).equals(page)) {
                        trail.pushItem(page);
                        log.debug("added page: " + page, new Object[0]);
                    }
                    log.debug("didn't add page because of refresh", new Object[0]);
                }
            } else {
                log.debug("didn't add page because it doesn't exist: " + page, new Object[0]);
            }
        }
        session.setAttribute(BREADCRUMBTRAIL_KEY, (Object)trail);
        JspWriter out = this.pageContext.getOut();
        int queueSize = trail.size();
        String linkclass = "wikipage";
        String curPage = null;
        int i = 0;
        while (i < queueSize - 1) {
            curPage = (String)trail.get(i);
            out.print("<a class=\"" + linkclass + "\" href=\"" + this.m_wikiContext.getViewURL(curPage) + "\">" + curPage + "</a>");
            if (i < queueSize - 2) {
                out.print(this.m_separator);
            }
            ++i;
        }
        return 0;
    }

    public static void deleteFromBreadCrumb(HttpServletRequest request, String pageName) {
        FixedQueue trail;
        HttpSession session = request.getSession(false);
        if (session != null && (trail = (FixedQueue)session.getAttribute(BREADCRUMBTRAIL_KEY)) != null) {
            trail.removeItem(pageName);
            session.setAttribute(BREADCRUMBTRAIL_KEY, (Object)trail);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FixedQueue
    extends LinkedList<String>
    implements Serializable {
        private int m_size;
        private static final long serialVersionUID = 0L;

        FixedQueue(int size) {
            this.m_size = size;
        }

        String pushItem(String pageName) {
            this.add(pageName);
            if (this.size() > this.m_size) {
                return (String)this.removeFirst();
            }
            return null;
        }

        public void removeItem(String pageName) {
            int i = 0;
            while (i < this.size()) {
                String page = (String)this.get(i);
                if (page != null && page.equals(pageName)) {
                    this.remove(page);
                }
                ++i;
            }
        }
    }
}

