/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.action.WikiContextFactory;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.attachment.AttachmentManager;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.tags.IteratorTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachmentsIteratorTag
extends IteratorTag<WikiPage> {
    private static final long serialVersionUID = 1L;
    private static final Collection<WikiPage> EMPTY_COLLECTION = Collections.unmodifiableCollection(new ArrayList());
    static Logger log = LoggerFactory.getLogger(AttachmentsIteratorTag.class);

    private Collection<WikiPage> getAttachments() {
        WikiContext wikiContext = WikiContextFactory.findContext(this.pageContext);
        WikiEngine engine = wikiContext.getEngine();
        AttachmentManager mgr = engine.getAttachmentManager();
        if (!mgr.attachmentsEnabled()) {
            return EMPTY_COLLECTION;
        }
        WikiPage page = wikiContext.getPage();
        try {
            if (page != null && engine.pageExists(page)) {
                return mgr.listAttachments(page);
            }
        }
        catch (ProviderException e) {
            log.error("Provider failed while trying to fetch attachments for page " + page.getName(), e);
        }
        return EMPTY_COLLECTION;
    }

    @Override
    protected Collection<WikiPage> initItems() {
        return this.getAttachments();
    }
}

