/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.search;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.content.PageNotFoundException;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.search.QueryItem;
import org.apache.wiki.search.SearchResult;

public class SearchMatcher {
    private QueryItem[] m_queries;
    private WikiEngine m_engine;

    public SearchMatcher(WikiEngine engine, QueryItem[] queries) {
        this.m_engine = engine;
        this.m_queries = queries;
    }

    public SearchResult matchPageContent(String wikiname, String pageText) throws IOException {
        if (this.m_queries == null) {
            return null;
        }
        int[] scores = new int[this.m_queries.length];
        BufferedReader in = new BufferedReader(new StringReader(pageText));
        String line = null;
        while ((line = in.readLine()) != null) {
            line = line.toLowerCase();
            int j = 0;
            while (j < this.m_queries.length) {
                int index = -1;
                while ((index = line.indexOf(this.m_queries[j].word, index + 1)) != -1) {
                    if (this.m_queries[j].type != -1) {
                        int n = j;
                        scores[n] = scores[n] + 1;
                        continue;
                    }
                    return null;
                }
                ++j;
            }
        }
        int totalscore = 0;
        int j = 0;
        while (j < scores.length) {
            if (wikiname.toLowerCase().indexOf(this.m_queries[j].word) != -1 && this.m_queries[j].type != -1) {
                int n = j;
                scores[n] = scores[n] + 5;
            }
            if (this.m_queries[j].type == 1 && scores[j] == 0) {
                return null;
            }
            totalscore += scores[j];
            ++j;
        }
        if (totalscore > 0) {
            try {
                return new SearchResultImpl(this.m_engine.getPage(wikiname), totalscore);
            }
            catch (PageNotFoundException e) {
                return null;
            }
            catch (ProviderException e) {
                return null;
            }
        }
        return null;
    }

    public class SearchResultImpl
    implements SearchResult {
        int m_score;
        WikiPage m_page;

        public SearchResultImpl(WikiPage page, int score) {
            this.m_page = page;
            this.m_score = score;
        }

        public WikiPage getPage() {
            return this.m_page;
        }

        public int getScore() {
            return this.m_score;
        }

        public String[] getContexts() {
            return new String[0];
        }
    }
}

