/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.search;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.NoRequiredPropertyException;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.FilterException;
import org.apache.wiki.api.WikiException;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.content.PageNotFoundException;
import org.apache.wiki.content.WikiPath;
import org.apache.wiki.event.WikiEvent;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.event.WikiEventManager;
import org.apache.wiki.event.WikiPageEvent;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.modules.InternalModule;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.search.BasicSearchProvider;
import org.apache.wiki.search.LuceneSearchProvider;
import org.apache.wiki.search.SearchProvider;
import org.apache.wiki.search.SearchResult;
import org.apache.wiki.util.ClassUtil;
import org.apache.wiki.util.TextUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchManager
implements InternalModule,
WikiEventListener {
    private static final Logger log = LoggerFactory.getLogger(SearchManager.class);
    private static final String DEFAULT_SEARCHPROVIDER = "org.apache.wiki.search.LuceneSearchProvider";
    private static final String PROP_USE_LUCENE = "jspwiki.useLucene";
    public static final String PROP_SEARCHPROVIDER = "jspwiki.searchProvider";
    private SearchProvider m_searchProvider = null;
    private WikiEngine m_engine = null;
    public static final String JSON_SEARCH = "search";

    public void initialize(WikiEngine engine, Properties properties) throws FilterException {
        this.m_engine = engine;
        this.loadSearchProvider(properties);
        WikiEventManager.addWikiEventListener(engine.getContentManager(), this);
        try {
            this.m_searchProvider.initialize(engine, properties);
        }
        catch (NoRequiredPropertyException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadSearchProvider(Properties properties) {
        String useLucene = properties.getProperty(PROP_USE_LUCENE);
        if (useLucene != null) {
            log.info("jspwiki.useLucene is deprecated; please use jspwiki.searchProvider=<your search provider> instead.", new Object[0]);
            this.m_searchProvider = TextUtil.isPositive(useLucene) ? new LuceneSearchProvider() : new BasicSearchProvider();
            log.debug("useLucene was set, loading search provider " + this.m_searchProvider, new Object[0]);
            return;
        }
        String providerClassName = properties.getProperty(PROP_SEARCHPROVIDER, DEFAULT_SEARCHPROVIDER);
        try {
            Class<?> providerClass = ClassUtil.findClass("org.apache.wiki.search", providerClassName);
            this.m_searchProvider = (SearchProvider)providerClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            log.warn("Failed loading SearchProvider, will use BasicSearchProvider.", e, new Object[0]);
        }
        catch (InstantiationException e) {
            log.warn("Failed loading SearchProvider, will use BasicSearchProvider.", e, new Object[0]);
        }
        catch (IllegalAccessException e) {
            log.warn("Failed loading SearchProvider, will use BasicSearchProvider.", e, new Object[0]);
        }
        if (this.m_searchProvider == null) {
            this.m_searchProvider = new BasicSearchProvider();
        }
        log.debug("Loaded search provider " + this.m_searchProvider, new Object[0]);
    }

    protected SearchProvider getSearchProvider() {
        return this.m_searchProvider;
    }

    public List<SearchResult> findPages(String query) throws ProviderException, IOException {
        if (query == null) {
            query = "";
        }
        List<SearchResult> c = this.m_searchProvider.findPages(query);
        return c;
    }

    private void removePage(WikiPage page) {
        try {
            this.m_searchProvider.pageRemoved(page);
        }
        catch (ProviderException e) {
            log.error("Unable to remove page from Search index", e);
        }
    }

    public void reindexPage(WikiPage page) throws ProviderException {
        this.m_searchProvider.reindexPage(page);
    }

    @Override
    public void actionPerformed(WikiEvent event) {
        if (!(event instanceof WikiPageEvent)) {
            return;
        }
        WikiPath pageName = ((WikiPageEvent)event).getPath();
        switch (event.getType()) {
            case 220: {
                WikiPage p;
                try {
                    p = this.m_engine.getPage(pageName);
                    this.removePage(p);
                }
                catch (PageNotFoundException e) {
                    throw new InternalWikiException("Page removed already!?! Page=" + pageName);
                }
                catch (ProviderException e) {
                    log.info("Could not reindex page " + pageName, e, new Object[0]);
                    e.printStackTrace();
                }
            }
            case 201: {
                WikiPage p;
                try {
                    p = this.m_engine.getPage(pageName);
                    this.reindexPage(p);
                    break;
                }
                catch (PageNotFoundException pageNotFoundException) {
                    break;
                }
                catch (ProviderException e) {
                    log.info("Could not reindex page " + pageName, e, new Object[0]);
                    e.printStackTrace();
                }
            }
        }
    }
}

