/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.search;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleHTMLEncoder;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.NoRequiredPropertyException;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.attachment.Attachment;
import org.apache.wiki.attachment.AttachmentManager;
import org.apache.wiki.content.PageAlreadyExistsException;
import org.apache.wiki.content.PageNotFoundException;
import org.apache.wiki.content.WikiPath;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.search.SearchProvider;
import org.apache.wiki.search.SearchResult;
import org.apache.wiki.util.ClassUtil;
import org.apache.wiki.util.FileUtil;
import org.apache.wiki.util.TextUtil;
import org.apache.wiki.util.WatchDog;
import org.apache.wiki.util.WikiBackgroundThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneSearchProvider
implements SearchProvider {
    protected static final Logger log = LoggerFactory.getLogger(LuceneSearchProvider.class);
    private WikiEngine m_engine;
    public static final String PROP_LUCENE_ANALYZER = "jspwiki.lucene.analyzer";
    private static final String PROP_LUCENE_INDEXDELAY = "jspwiki.lucene.indexdelay";
    private static final String PROP_LUCENE_INITIALDELAY = "jspwiki.lucene.initialdelay";
    private String m_analyzerClass = "org.apache.lucene.analysis.standard.StandardAnalyzer";
    private static final String LUCENE_DIR = "lucene";
    public static final int LUCENE_OPTIMIZE_COUNT = 10;
    public static final String[] SEARCHABLE_FILE_SUFFIXES = new String[]{".txt", ".ini", ".xml", ".html", "htm", ".mm", ".htm", ".xhtml", ".java", ".c", ".cpp", ".php", ".asm", ".sh", ".properties", ".kml", ".gpx", ".loc"};
    protected static final String LUCENE_ID = "id";
    protected static final String LUCENE_PAGE_CONTENTS = "contents";
    protected static final String LUCENE_AUTHOR = "author";
    protected static final String LUCENE_ATTACHMENTS = "attachment";
    protected static final String LUCENE_PAGE_NAME = "name";
    private String m_luceneDirectory = null;
    private int m_updateCount = 0;
    protected Vector<Object[]> m_updates = new Vector();
    private static final int MAX_FRAGMENTS = 3;
    private static String c_punctuationSpaces = StringUtils.repeat((String)" ", (int)" ()&+,-=._$".length());
    public static final int FLAG_CONTEXTS = 1;

    @Override
    public void initialize(WikiEngine engine, Properties props) throws NoRequiredPropertyException, IOException {
        this.m_engine = engine;
        this.m_luceneDirectory = String.valueOf(engine.getWorkDir()) + File.separator + LUCENE_DIR;
        int initialDelay = TextUtil.getIntegerProperty(props, PROP_LUCENE_INITIALDELAY, 60);
        int indexDelay = TextUtil.getIntegerProperty(props, PROP_LUCENE_INDEXDELAY, 15);
        this.m_analyzerClass = TextUtil.getStringProperty(props, PROP_LUCENE_ANALYZER, this.m_analyzerClass);
        File dir = new File(this.m_luceneDirectory);
        log.info("Lucene enabled, cache will be in: " + dir.getAbsolutePath(), new Object[0]);
        try {
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (!(dir.exists() && dir.canWrite() && dir.canRead())) {
                log.error("Cannot write to Lucene directory, disabling Lucene: " + dir.getAbsolutePath(), new Object[0]);
                throw new IOException("Invalid Lucene directory.");
            }
            String[] filelist = dir.list();
            if (filelist == null) {
                throw new IOException("Invalid Lucene directory: cannot produce listing: " + dir.getAbsolutePath());
            }
        }
        catch (IOException e) {
            log.error("Problem while creating Lucene index - not using Lucene.", e);
        }
        LuceneUpdater updater = new LuceneUpdater(this.m_engine, this, initialDelay, indexDelay);
        updater.start();
    }

    protected WikiEngine getEngine() {
        return this.m_engine;
    }

    protected void doFullLuceneReindex() throws IOException {
        block21: {
            File dir = new File(this.m_luceneDirectory);
            String[] filelist = dir.list();
            if (filelist == null) {
                throw new IOException("Invalid Lucene directory: cannot produce listing: " + dir.getAbsolutePath());
            }
            try {
                if (filelist.length == 0) {
                    Date start = new Date();
                    IndexWriter writer = null;
                    log.info("Starting Lucene reindexing, this can take a couple minutes...", new Object[0]);
                    FSDirectory luceneDir = FSDirectory.getDirectory((File)dir, (boolean)false);
                    if (IndexReader.isLocked((Directory)luceneDir)) {
                        log.info("JSPWiki was shut down while Lucene was indexing - unlocking now.", new Object[0]);
                        IndexReader.unlock((Directory)luceneDir);
                    }
                    try {
                        writer = new IndexWriter(this.m_luceneDirectory, this.getLuceneAnalyzer(), true);
                        List<WikiPage> allPages = this.m_engine.getContentManager().getAllPages(null);
                        for (WikiPage page : allPages) {
                            try {
                                String text = page.getContentAsString();
                                this.luceneIndexPage(page, text, writer);
                            }
                            catch (Exception e) {
                                log.info("Unable to index page, continuing to next: " + page.getName(), e, new Object[0]);
                            }
                        }
                        writer.optimize();
                    }
                    finally {
                        try {
                            if (writer != null) {
                                writer.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                    Date end = new Date();
                    log.info("Full Lucene index finished in " + (end.getTime() - start.getTime()) + " milliseconds.", new Object[0]);
                    break block21;
                }
                log.info("Files found in Lucene directory, not reindexing.", new Object[0]);
            }
            catch (NoClassDefFoundError e) {
                log.info("Lucene libraries do not exist - not using Lucene.", new Object[0]);
            }
            catch (IOException e) {
                log.error("Problem while creating Lucene index - not using Lucene.", e);
            }
            catch (ProviderException e) {
                log.error("Problem reading pages while creating Lucene index (JSPWiki won't start.)", e);
                throw new IllegalArgumentException("unable to create Lucene index");
            }
            catch (ClassNotFoundException e) {
                log.error("Illegal Analyzer specified:", e);
            }
            catch (Exception e) {
                log.error("Unable to start lucene", e);
            }
        }
    }

    protected String getAttachmentContent(String attachmentName, int version) {
        AttachmentManager mgr = this.m_engine.getAttachmentManager();
        try {
            Attachment att = mgr.getAttachmentInfo(attachmentName, version);
            return this.getAttachmentContent(att);
        }
        catch (PageNotFoundException e) {
            log.error("Attachment cannot be loaded", e);
        }
        catch (ProviderException e) {
            log.error("Attachment cannot be loaded", e);
        }
        return null;
    }

    protected String getAttachmentContent(Attachment att) {
        AttachmentManager mgr = this.m_engine.getAttachmentManager();
        String filename = att.getFileName();
        boolean searchSuffix = false;
        String[] stringArray = SEARCHABLE_FILE_SUFFIXES;
        int n = SEARCHABLE_FILE_SUFFIXES.length;
        int n2 = 0;
        while (n2 < n) {
            String suffix = stringArray[n2];
            if (filename.endsWith(suffix)) {
                searchSuffix = true;
            }
            ++n2;
        }
        if (searchSuffix) {
            try {
                InputStream attStream = mgr.getAttachmentStream(att);
                StringWriter sout = new StringWriter();
                FileUtil.copyContents(new InputStreamReader(attStream), sout);
                attStream.close();
                sout.close();
                return sout.toString();
            }
            catch (ProviderException e) {
                log.error("Attachment cannot be loaded", e);
                return null;
            }
            catch (IOException e) {
                log.error("Attachment cannot be loaded", e);
                return null;
            }
        }
        return null;
    }

    protected synchronized void updateLuceneIndex(WikiPage page, String text) {
        block19: {
            IndexWriter writer = null;
            log.debug("Updating Lucene index for page '" + page.getName() + "'...", new Object[0]);
            try {
                this.pageRemoved(page);
                writer = new IndexWriter(this.m_luceneDirectory, this.getLuceneAnalyzer(), false);
                this.luceneIndexPage(page, text, writer);
                ++this.m_updateCount;
                if (this.m_updateCount >= 10) {
                    writer.optimize();
                    this.m_updateCount = 0;
                }
            }
            catch (IOException e) {
                log.error("Unable to update page '" + page.getName() + "' from Lucene index", e);
                try {
                    if (writer != null) {
                        writer.close();
                    }
                    break block19;
                }
                catch (IOException iOException) {}
                break block19;
            }
            catch (Exception e) {
                try {
                    log.error("Unexpected Lucene exception - please check configuration!", e);
                    break block19;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        log.debug("Done updating Lucene index for page '" + page.getName() + "'.", new Object[0]);
    }

    private Analyzer getLuceneAnalyzer() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clazz = ClassUtil.findClass("", this.m_analyzerClass);
        Analyzer analyzer = (Analyzer)clazz.newInstance();
        return analyzer;
    }

    protected Document luceneIndexPage(WikiPage page, String text, IndexWriter writer) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Indexing " + page.getName() + "...", new Object[0]);
        }
        Document doc = new Document();
        if (text == null) {
            return doc;
        }
        Field field = new Field(LUCENE_ID, page.getName(), Field.Store.YES, Field.Index.UN_TOKENIZED);
        doc.add(field);
        field = new Field(LUCENE_PAGE_CONTENTS, text, Field.Store.YES, Field.Index.TOKENIZED, Field.TermVector.NO);
        doc.add(field);
        String unTokenizedTitle = StringUtils.replaceChars((String)page.getName(), (String)" ()&+,-=._$", (String)c_punctuationSpaces);
        field = new Field(LUCENE_PAGE_NAME, String.valueOf(TextUtil.beautifyString(page.getName())) + " " + unTokenizedTitle, Field.Store.YES, Field.Index.TOKENIZED, Field.TermVector.NO);
        doc.add(field);
        if (page.getAuthor() != null) {
            field = new Field(LUCENE_AUTHOR, page.getAuthor(), Field.Store.YES, Field.Index.TOKENIZED, Field.TermVector.NO);
            doc.add(field);
        }
        try {
            List<WikiPage> attachments = this.m_engine.getAttachmentManager().listAttachments(page);
            String attachmentNames = "";
            for (WikiPage att : attachments) {
                attachmentNames = String.valueOf(attachmentNames) + att.getName() + ";";
            }
            field = new Field(LUCENE_ATTACHMENTS, attachmentNames, Field.Store.YES, Field.Index.TOKENIZED, Field.TermVector.NO);
            doc.add(field);
        }
        catch (ProviderException e) {
            log.error("Failed to get attachments for page", e);
        }
        writer.addDocument(doc);
        return doc;
    }

    @Override
    public void pageRemoved(WikiPage page) {
        try {
            IndexReader reader = IndexReader.open((String)this.m_luceneDirectory);
            reader.deleteDocuments(new Term(LUCENE_ID, page.getName()));
            reader.close();
        }
        catch (IOException e) {
            log.error("Unable to update page '" + page.getName() + "' from Lucene index", e);
        }
    }

    @Override
    public void reindexPage(WikiPage page) throws ProviderException {
        if (page != null) {
            String text = page.isAttachment() ? this.getAttachmentContent((Attachment)page) : page.getContentAsString();
            Object[] pair = new Object[]{page, text};
            this.m_updates.add(pair);
            log.debug("Scheduling page " + page.getName() + " for index update", new Object[0]);
        }
    }

    @Override
    public List<SearchResult> findPages(String query) throws ProviderException {
        return this.findPages(query, 1);
    }

    public List<SearchResult> findPages(String query, int flags) throws ProviderException {
        IndexSearcher searcher = null;
        ArrayList<SearchResultImpl> list = null;
        Highlighter highlighter = null;
        try {
            String[] queryfields = new String[]{LUCENE_PAGE_CONTENTS, LUCENE_PAGE_NAME, LUCENE_AUTHOR, LUCENE_ATTACHMENTS};
            MultiFieldQueryParser qp = new MultiFieldQueryParser(queryfields, this.getLuceneAnalyzer());
            Query luceneQuery = qp.parse(query);
            if ((flags & 1) != 0) {
                highlighter = new Highlighter((Formatter)new SimpleHTMLFormatter("<span class=\"searchmatch\">", "</span>"), (Encoder)new SimpleHTMLEncoder(), (Scorer)new QueryScorer(luceneQuery));
            }
            try {
                searcher = new IndexSearcher(this.m_luceneDirectory);
            }
            catch (Exception ex) {
                log.info("Lucene not yet ready; indexing not started", ex, new Object[0]);
                if (searcher != null) {
                    try {
                        searcher.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return null;
            }
            try {
                Hits hits = searcher.search(luceneQuery);
                list = new ArrayList<SearchResultImpl>(hits.length());
                int curr = 0;
                while (curr < hits.length()) {
                    WikiPage page;
                    Document doc = hits.doc(curr);
                    String pageName = doc.get(LUCENE_ID);
                    try {
                        page = this.m_engine.getPage(pageName, -1);
                        page.isAttachment();
                        int score = (int)(hits.score(curr) * 100.0f);
                        String text = doc.get(LUCENE_PAGE_CONTENTS);
                        String[] fragments = new String[]{};
                        if (text != null && highlighter != null) {
                            TokenStream tokenStream = this.getLuceneAnalyzer().tokenStream(LUCENE_PAGE_CONTENTS, (Reader)new StringReader(text));
                            fragments = highlighter.getBestFragments(tokenStream, text, 3);
                        }
                        SearchResultImpl result = new SearchResultImpl(page, score, fragments);
                        list.add(result);
                    }
                    catch (PageNotFoundException e) {
                        log.error("Lucene found a result page '" + pageName + "' that could not be loaded, removing from Lucene cache", new Object[0]);
                        try {
                            page = this.m_engine.createPage(WikiPath.valueOf(pageName));
                            this.pageRemoved(page);
                            this.m_engine.deletePage(pageName);
                        }
                        catch (PageAlreadyExistsException e1) {
                            throw new ProviderException(e1.getMessage(), e1);
                        }
                    }
                    ++curr;
                }
            }
            catch (IOException e) {
                log.error("Failed during lucene search", e);
            }
            catch (InstantiationException e) {
                log.error("Unable to get a Lucene analyzer", e);
            }
            catch (IllegalAccessException e) {
                log.error("Unable to get a Lucene analyzer", e);
            }
            catch (ClassNotFoundException e) {
                log.error("Specified Lucene analyzer does not exist", e);
            }
            catch (ParseException e) {
                log.info("Broken query; cannot parse", e, new Object[0]);
                throw new ProviderException("You have entered a query Lucene cannot process: " + e.getMessage());
            }
        }
        finally {
            if (searcher != null) {
                try {
                    searcher.close();
                }
                catch (IOException iOException) {}
            }
        }
        return list;
    }

    @Override
    public String getProviderInfo() {
        return "LuceneSearchProvider";
    }

    private static final class LuceneUpdater
    extends WikiBackgroundThread {
        protected static final int INDEX_DELAY = 15;
        protected static final int INITIAL_DELAY = 60;
        private final LuceneSearchProvider m_provider;
        private int m_initialDelay;
        private WatchDog m_watchdog;

        private LuceneUpdater(WikiEngine engine, LuceneSearchProvider provider, int initialDelay, int indexDelay) {
            super(engine, indexDelay);
            this.m_provider = provider;
            this.setName("Lucene Indexer");
        }

        public void startupTask() throws Exception {
            this.m_watchdog = this.getEngine().getCurrentWatchDog();
            try {
                Thread.sleep((long)this.m_initialDelay * 1000L);
            }
            catch (InterruptedException e) {
                throw new InternalWikiException("Interrupted while waiting to start.");
            }
            this.m_watchdog.enterState("Full reindex");
            this.m_provider.doFullLuceneReindex();
            this.m_watchdog.exitState();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void backgroundTask() throws Exception {
            this.m_watchdog.enterState("Emptying index queue", 60);
            Vector<Object[]> vector = this.m_provider.m_updates;
            synchronized (vector) {
                while (this.m_provider.m_updates.size() > 0) {
                    Object[] pair = this.m_provider.m_updates.remove(0);
                    WikiPage page = (WikiPage)pair[0];
                    String text = (String)pair[1];
                    this.m_provider.updateLuceneIndex(page, text);
                }
            }
            this.m_watchdog.exitState();
        }
    }

    private static class SearchResultImpl
    implements SearchResult {
        private WikiPage m_page;
        private int m_score;
        private String[] m_contexts;

        public SearchResultImpl(WikiPage page, int score, String[] contexts) {
            this.m_page = page;
            this.m_score = score;
            this.m_contexts = contexts;
        }

        public WikiPage getPage() {
            return this.m_page;
        }

        public int getScore() {
            return this.m_score;
        }

        public String[] getContexts() {
            return this.m_contexts;
        }
    }
}

