/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.wiki.NoRequiredPropertyException;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.search.QueryItem;
import org.apache.wiki.search.SearchMatcher;
import org.apache.wiki.search.SearchProvider;
import org.apache.wiki.search.SearchResult;
import org.apache.wiki.search.SearchResultComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicSearchProvider
implements SearchProvider {
    private static final Logger log = LoggerFactory.getLogger(BasicSearchProvider.class);
    private WikiEngine m_engine;

    @Override
    public void initialize(WikiEngine engine, Properties props) throws NoRequiredPropertyException, IOException {
        this.m_engine = engine;
    }

    @Override
    public void pageRemoved(WikiPage page) {
    }

    @Override
    public void reindexPage(WikiPage page) throws ProviderException {
    }

    public QueryItem[] parseQuery(String query) {
        StringTokenizer st = new StringTokenizer(query, " \t,");
        QueryItem[] items = new QueryItem[st.countTokens()];
        int word = 0;
        log.debug("Expecting " + items.length + " items", new Object[0]);
        while (st.hasMoreTokens()) {
            log.debug("Item " + word, new Object[0]);
            String token = st.nextToken().toLowerCase();
            items[word] = new QueryItem();
            switch (token.charAt(0)) {
                case '+': {
                    items[word].type = 1;
                    token = token.substring(1);
                    log.debug("Required word: " + token, new Object[0]);
                    break;
                }
                case '-': {
                    items[word].type = -1;
                    token = token.substring(1);
                    log.debug("Forbidden word: " + token, new Object[0]);
                    break;
                }
                default: {
                    items[word].type = 0;
                    log.debug("Requested word: " + token, new Object[0]);
                }
            }
            items[word++].word = token;
        }
        return items;
    }

    private String attachmentNames(WikiPage page, String separator) {
        if (this.m_engine.getAttachmentManager().hasAttachments(page)) {
            List<WikiPage> attachments;
            try {
                attachments = this.m_engine.getAttachmentManager().listAttachments(page);
            }
            catch (ProviderException e) {
                log.error("Unable to get attachments for page", e);
                return "";
            }
            StringBuilder attachmentNames = new StringBuilder();
            Iterator it = attachments.iterator();
            while (it.hasNext()) {
                WikiPage att = (WikiPage)it.next();
                attachmentNames.append(att.getName());
                if (!it.hasNext()) continue;
                attachmentNames.append(separator);
            }
            return attachmentNames.toString();
        }
        return "";
    }

    private SortedSet<SearchResult> findPages(QueryItem[] query) {
        TreeSet<SearchResult> res = new TreeSet<SearchResult>(new SearchResultComparator());
        SearchMatcher matcher = new SearchMatcher(this.m_engine, query);
        List<WikiPage> allPages = null;
        try {
            allPages = this.m_engine.getContentManager().getAllPages(null);
        }
        catch (ProviderException pe) {
            log.error("Unable to retrieve page list", pe);
            return null;
        }
        for (WikiPage page : allPages) {
            try {
                String pageContent;
                String pageName;
                SearchResult comparison;
                if (page == null || (comparison = matcher.matchPageContent(pageName = page.getName(), pageContent = String.valueOf(page.getContentAsString()) + this.attachmentNames(page, " "))) == null) continue;
                res.add(comparison);
            }
            catch (ProviderException pe) {
                log.error("Unable to retrieve page from cache", pe);
            }
            catch (IOException ioe) {
                log.error("Failed to search page", ioe);
            }
        }
        return res;
    }

    @Override
    public List<SearchResult> findPages(String query) {
        return new ArrayList<SearchResult>(this.findPages(this.parseQuery(query)));
    }

    @Override
    public String getProviderInfo() {
        return "BasicSearchProvider";
    }
}

