/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.rss;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.rss.RSSGenerator;
import org.apache.wiki.util.FileUtil;
import org.apache.wiki.util.WatchDog;
import org.apache.wiki.util.WikiBackgroundThread;

public class RSSThread
extends WikiBackgroundThread {
    static Logger log = LoggerFactory.getLogger(RSSThread.class);
    private final File m_rssFile;
    private final int m_rssInterval;
    private final RSSGenerator m_generator;
    private WatchDog m_watchdog;

    public RSSThread(WikiEngine engine, File rssFile, int rssInterval) {
        super(engine, rssInterval);
        this.m_generator = engine.getRSSGenerator();
        this.m_rssFile = rssFile;
        this.m_rssInterval = rssInterval;
        this.setName("RSS Generator");
        log.debug("RSS file will be at " + this.m_rssFile.getAbsolutePath(), new Object[0]);
        log.debug("RSS refresh interval (seconds): " + this.m_rssInterval, new Object[0]);
    }

    public void startupTask() throws Exception {
        this.m_watchdog = this.getEngine().getCurrentWatchDog();
    }

    public void backgroundTask() throws Exception {
        if (this.m_generator.isEnabled()) {
            Writer out = null;
            Reader in = null;
            this.m_watchdog.enterState("Generating RSS feed", 60);
            try {
                try {
                    log.debug("Regenerating RSS feed to " + this.m_rssFile, new Object[0]);
                    String feed = this.m_generator.generate();
                    in = new StringReader(feed);
                    out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.m_rssFile), "UTF-8"));
                    FileUtil.copyContents(in, out);
                }
                catch (IOException e) {
                    log.error("Cannot generate RSS feed to " + this.m_rssFile.getAbsolutePath(), e);
                    this.m_generator.setEnabled(false);
                    try {
                        if (in != null) {
                            in.close();
                        }
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException e2) {
                        log.error("Could not close I/O for RSS", e2);
                        this.m_generator.setEnabled(false);
                    }
                    this.m_watchdog.exitState();
                }
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e) {
                    log.error("Could not close I/O for RSS", e);
                    this.m_generator.setEnabled(false);
                }
                this.m_watchdog.exitState();
            }
        }
    }
}

