/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.rss;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.wiki.NoRequiredPropertyException;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiSession;
import org.apache.wiki.api.WikiException;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.auth.permissions.PagePermission;
import org.apache.wiki.content.PageAlreadyExistsException;
import org.apache.wiki.content.PageNotFoundException;
import org.apache.wiki.content.WikiPath;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.rss.AtomFeed;
import org.apache.wiki.rss.Entry;
import org.apache.wiki.rss.Feed;
import org.apache.wiki.rss.RSS10Feed;
import org.apache.wiki.rss.RSS20Feed;
import org.apache.wiki.ui.stripes.WikiActionBeanContext;
import org.apache.wiki.util.PageTimeComparator;
import org.apache.wiki.util.TextUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSSGenerator {
    static Logger log = LoggerFactory.getLogger(RSSGenerator.class);
    private WikiEngine m_engine;
    private String m_channelDescription = "";
    private String m_channelLanguage = "en-us";
    private boolean m_enabled = true;
    public static final String RSS10 = "rss10";
    public static final String RSS20 = "rss20";
    public static final String ATOM = "atom";
    public static final String MODE_BLOG = "blog";
    public static final String MODE_WIKI = "wiki";
    public static final String MODE_FULL = "full";
    public static final String PROP_CHANNEL_DESCRIPTION = "jspwiki.rss.channelDescription";
    public static final String PROP_CHANNEL_LANGUAGE = "jspwiki.rss.channelLanguage";
    public static final String PROP_CHANNEL_TITLE = "jspwiki.rss.channelTitle";
    public static final String PROP_GENERATE_RSS = "jspwiki.rss.generate";
    public static final String PROP_RSSFILE = "jspwiki.rss.fileName";
    public static final String PROP_INTERVAL = "jspwiki.rss.interval";
    public static final String PROP_RSS_AUTHOR = "jspwiki.rss.author";
    public static final String PROP_RSS_AUTHOREMAIL = "jspwiki.rss.author.email";
    public static final String PROP_RSS_COPYRIGHT = "jspwiki.rss.copyright";
    public static final String PROP_RSSAUTHOR = "jspwiki.rss.author";
    public static final String PROP_RSSAUTHOREMAIL = "jspwiki.rss.author.email";
    private static final int MAX_CHARACTERS = 0x7FFFFFFE;

    public RSSGenerator(WikiEngine engine, Properties properties) throws NoRequiredPropertyException {
        this.m_engine = engine;
        if (engine.getBaseURL() == null || engine.getBaseURL().length() == 0) {
            throw new NoRequiredPropertyException("RSS requires jspwiki.baseURL to be set!", "jspwiki.baseURL");
        }
        this.m_channelDescription = properties.getProperty(PROP_CHANNEL_DESCRIPTION, this.m_channelDescription);
        this.m_channelLanguage = properties.getProperty(PROP_CHANNEL_LANGUAGE, this.m_channelLanguage);
    }

    public static String format(String s) {
        s = TextUtil.replaceString(s, "&", "&amp;");
        s = TextUtil.replaceString(s, "<", "&lt;");
        s = TextUtil.replaceString(s, "]]>", "]]&gt;");
        return s.trim();
    }

    private String getAuthor(WikiPage page) {
        String author = page.getAuthor();
        if (author == null) {
            author = "An unknown author";
        }
        return author;
    }

    private String getAttachmentDescription(WikiPage att) {
        String author = this.getAuthor(att);
        StringBuilder sb = new StringBuilder();
        if (att.getVersion() != 1) {
            sb.append(String.valueOf(author) + " uploaded a new version of this attachment on " + att.getLastModified());
        } else {
            sb.append(String.valueOf(author) + " created this attachment on " + att.getLastModified());
        }
        sb.append("<br /><hr /><br />");
        try {
            sb.append("Parent page: <a href=\"" + this.m_engine.getURL(WikiContext.VIEW, att.getParent().getName(), null, true) + "\">" + att.getParent().getName() + "</a><br />");
            sb.append("Info page: <a href=\"" + this.m_engine.getURL(WikiContext.INFO, att.getParent().getName(), null, true) + "\">" + att.getName() + "</a>");
        }
        catch (PageNotFoundException e) {
            log.debug("Unable to load parent", e, new Object[0]);
        }
        catch (ProviderException e) {
            log.debug("Unable to load parent", e, new Object[0]);
        }
        return sb.toString();
    }

    private String getPageDescription(WikiPage page) throws PageNotFoundException, ProviderException {
        StringBuilder buf = new StringBuilder();
        String author = this.getAuthor(page);
        WikiActionBeanContext ctx = this.m_engine.getWikiContextFactory().newViewContext(page);
        if (page.getVersion() > 1) {
            String diff = this.m_engine.getDiff(ctx, page.getVersion() - 1, page.getVersion());
            buf.append(String.valueOf(author) + " changed this page on " + page.getLastModified() + ":<br /><hr /><br />");
            buf.append(diff);
        } else {
            buf.append(String.valueOf(author) + " created this page on " + page.getLastModified() + ":<br /><hr /><br />");
            buf.append(this.m_engine.getHTML(page.getName()));
        }
        return buf.toString();
    }

    private String getEntryDescription(WikiPage page) {
        String res = "";
        try {
            res = page.isAttachment() ? this.getAttachmentDescription(page) : this.getPageDescription(page);
        }
        catch (PageNotFoundException e) {
            log.error("Unable to get description", e);
        }
        catch (ProviderException e) {
            log.error("Unable to get description", e);
        }
        return res;
    }

    private String getEntryTitle(WikiPage page) {
        return String.valueOf(page.getName()) + ", version " + page.getVersion();
    }

    public String generate() throws WikiException {
        WikiActionBeanContext context = this.m_engine.getWikiContextFactory().newContext(null, null, WikiContext.RSS);
        try {
            context.setPage(this.m_engine.createPage(WikiPath.valueOf("__DUMMY")));
        }
        catch (PageAlreadyExistsException e) {
            try {
                context.setPage(this.m_engine.getPage("__DUMMY"));
            }
            catch (PageNotFoundException e1) {
                throw new WikiException(e1.getMessage(), e1);
            }
        }
        RSS10Feed feed = new RSS10Feed(context);
        String result = this.generateFullWikiRSS(context, feed);
        result = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + result;
        return result;
    }

    public static String getContentType(String mode) {
        if (mode.equals(RSS10) || mode.equals(RSS20)) {
            return "application/rss+xml";
        }
        if (mode.equals(ATOM)) {
            return "application/atom+xml";
        }
        return "application/octet-stream";
    }

    public String generateFeed(WikiContext wikiContext, List<WikiPage> changed, String mode, String type) throws ProviderException, IllegalArgumentException {
        Feed feed = null;
        String res = null;
        feed = ATOM.equals(type) ? new AtomFeed(wikiContext) : (RSS20.equals(type) ? new RSS20Feed(wikiContext) : new RSS10Feed(wikiContext));
        feed.setMode(mode);
        if (MODE_BLOG.equals(mode)) {
            res = this.generateBlogRSS(wikiContext, changed, feed);
        } else if (MODE_FULL.equals(mode)) {
            res = this.generateFullWikiRSS(wikiContext, feed);
        } else if (MODE_WIKI.equals(mode)) {
            res = this.generateWikiPageRSS(wikiContext, changed, feed);
        } else {
            throw new IllegalArgumentException("Invalid value for feed mode: " + mode);
        }
        return res;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public synchronized void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    protected String generateFullWikiRSS(WikiContext wikiContext, Feed feed) throws ProviderException {
        feed.setChannelTitle(this.m_engine.getApplicationName());
        feed.setFeedURL(this.m_engine.getBaseURL());
        feed.setChannelLanguage(this.m_channelLanguage);
        feed.setChannelDescription(this.m_channelDescription);
        List<WikiPage> changed = this.m_engine.getRecentChanges(wikiContext.getPage().getWiki());
        WikiSession session = WikiSession.guestSession(this.m_engine);
        int items = 0;
        Iterator i = changed.iterator();
        while (i.hasNext() && items < 15) {
            WikiPage page = (WikiPage)i.next();
            if (this.m_engine.getAuthorizationManager().checkPermission(session, new PagePermission(page, "view"))) {
                Entry e = new Entry();
                e.setPage(page);
                String url = page.isAttachment() ? this.m_engine.getURL(WikiContext.ATTACH, page.getName(), null, true) : this.m_engine.getURL(WikiContext.VIEW, page.getName(), null, true);
                e.setURL(url);
                e.setTitle(page.getName());
                e.setContent(this.getEntryDescription(page));
                e.setAuthor(this.getAuthor(page));
                feed.addEntry(e);
            }
            ++items;
        }
        return feed.getString();
    }

    protected String generateWikiPageRSS(WikiContext wikiContext, List changed, Feed feed) throws ProviderException {
        feed.setChannelTitle(String.valueOf(this.m_engine.getApplicationName()) + ": " + wikiContext.getPage().getName());
        feed.setFeedURL(wikiContext.getViewURL(wikiContext.getPage().getName()));
        String language = this.m_engine.getVariable(wikiContext, PROP_CHANNEL_LANGUAGE);
        if (language != null) {
            feed.setChannelLanguage(language);
        } else {
            feed.setChannelLanguage(this.m_channelLanguage);
        }
        String channelDescription = this.m_engine.getVariable(wikiContext, PROP_CHANNEL_DESCRIPTION);
        if (channelDescription != null) {
            feed.setChannelDescription(channelDescription);
        }
        Collections.sort(changed, PageTimeComparator.DEFAULT_PAGETIME_COMPARATOR);
        int items = 0;
        Iterator i = changed.iterator();
        while (i.hasNext() && items < 15) {
            WikiPage page = (WikiPage)i.next();
            Entry e = new Entry();
            e.setPage(page);
            String url = page.isAttachment() ? this.m_engine.getURL(WikiContext.ATTACH, page.getName(), "version=" + page.getVersion(), true) : this.m_engine.getURL(WikiContext.VIEW, page.getName(), "version=" + page.getVersion(), true);
            url = TextUtil.replaceString(url, "&amp;", "&");
            e.setURL(url);
            e.setTitle(this.getEntryTitle(page));
            e.setContent(this.getEntryDescription(page));
            e.setAuthor(this.getAuthor(page));
            feed.addEntry(e);
            ++items;
        }
        return feed.getString();
    }

    protected String generateBlogRSS(WikiContext wikiContext, List changed, Feed feed) throws ProviderException {
        String ctitle;
        if (log.isDebugEnabled()) {
            log.debug("Generating RSS for blog, size=" + changed.size(), new Object[0]);
        }
        if ((ctitle = this.m_engine.getVariable(wikiContext, PROP_CHANNEL_TITLE)) != null) {
            feed.setChannelTitle(ctitle);
        } else {
            feed.setChannelTitle(String.valueOf(this.m_engine.getApplicationName()) + ":" + wikiContext.getPage().getName());
        }
        feed.setFeedURL(wikiContext.getViewURL(wikiContext.getPage().getName()));
        String language = this.m_engine.getVariable(wikiContext, PROP_CHANNEL_LANGUAGE);
        if (language != null) {
            feed.setChannelLanguage(language);
        } else {
            feed.setChannelLanguage(this.m_channelLanguage);
        }
        String channelDescription = this.m_engine.getVariable(wikiContext, PROP_CHANNEL_DESCRIPTION);
        if (channelDescription != null) {
            feed.setChannelDescription(channelDescription);
        }
        Collections.sort(changed, PageTimeComparator.DEFAULT_PAGETIME_COMPARATOR);
        int items = 0;
        Iterator i = changed.iterator();
        while (i.hasNext() && items < 15) {
            WikiPage page = (WikiPage)i.next();
            Entry e = new Entry();
            e.setPage(page);
            String url = page.isAttachment() ? this.m_engine.getURL(WikiContext.ATTACH, page.getName(), null, true) : this.m_engine.getURL(WikiContext.VIEW, page.getName(), null, true);
            e.setURL(url);
            String pageText = this.m_engine.getPureText(page.getName(), -1);
            String title = "";
            int firstLine = pageText.indexOf(10);
            if (firstLine > 0) {
                title = pageText.substring(0, firstLine).trim();
            }
            if (title.length() == 0) {
                title = page.getName();
            }
            while (title.startsWith("!")) {
                title = title.substring(1);
            }
            e.setTitle(title);
            if (firstLine > 0) {
                int maxlen = pageText.length();
                if (maxlen > 0x7FFFFFFE) {
                    maxlen = 0x7FFFFFFE;
                }
                if (maxlen > 0) {
                    pageText = this.m_engine.textToHTML(wikiContext, pageText.substring(firstLine + 1, maxlen).trim());
                    if (maxlen == 0x7FFFFFFE) {
                        pageText = String.valueOf(pageText) + "...";
                    }
                    e.setContent(pageText);
                } else {
                    e.setContent(title);
                }
            } else {
                e.setContent(title);
            }
            e.setAuthor(this.getAuthor(page));
            feed.addEntry(e);
            ++items;
        }
        return feed.getString();
    }
}

