/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.rpc.json;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.security.Permission;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiSession;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.permissions.PagePermission;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.rpc.RPCCallable;
import org.apache.wiki.rpc.RPCManager;
import org.jabsorb.JSONRPCBridge;
import org.jabsorb.callback.InvocationCallback;

public final class JSONRPCManager
extends RPCManager {
    private static final String JSONRPCBRIDGE = "JSONRPCBridge";
    private static HashMap<String, CallbackContainer> c_globalObjects = new HashMap();

    private JSONRPCManager() {
    }

    public static String emitJSONCall(WikiContext context, RPCCallable c, String function, String params) {
        StringBuilder sb = new StringBuilder();
        sb.append("<script>");
        sb.append("var result = jsonrpc." + JSONRPCManager.getId(c) + "." + function + "(" + params + ");\r\n");
        sb.append("document.write(result);\r\n");
        sb.append("</script>");
        return sb.toString();
    }

    private static JSONRPCBridge getBridge(WikiContext context) {
        HttpSession hs;
        JSONRPCBridge bridge = null;
        HttpServletRequest req = context.getHttpRequest();
        if (req != null && (hs = req.getSession()) != null && (bridge = (JSONRPCBridge)hs.getAttribute(JSONRPCBRIDGE)) == null) {
            bridge = new JSONRPCBridge();
            hs.setAttribute(JSONRPCBRIDGE, (Object)bridge);
        }
        if (bridge == null) {
            bridge = JSONRPCBridge.getGlobalBridge();
        }
        return bridge;
    }

    public static String registerJSONObject(WikiContext context, RPCCallable c) {
        String id = JSONRPCManager.getId(c);
        JSONRPCManager.getBridge(context).registerObject((Object)id, (Object)c);
        JSONRPCManager.requestJSON(context);
        return id;
    }

    public static void requestJSON(WikiContext context) {
        JSONRPCManager.getBridge(context).registerCallback((InvocationCallback)new WikiJSONAccessor(), HttpServletRequest.class);
    }

    public static void registerGlobalObject(String id, RPCCallable object) {
        JSONRPCManager.registerGlobalObject(id, object, PagePermission.VIEW);
    }

    public static void registerGlobalObject(String id, RPCCallable object, Permission perm) {
        CallbackContainer cc = new CallbackContainer();
        cc.m_permission = perm;
        cc.m_id = id;
        cc.m_object = object;
        c_globalObjects.put(id, cc);
    }

    public static void sessionCreated(HttpSession session) {
        JSONRPCBridge bridge = (JSONRPCBridge)session.getAttribute(JSONRPCBRIDGE);
        if (bridge == null) {
            bridge = new JSONRPCBridge();
            session.setAttribute(JSONRPCBRIDGE, (Object)bridge);
        }
        WikiJSONAccessor acc = new WikiJSONAccessor();
        bridge.registerCallback((InvocationCallback)acc, HttpServletRequest.class);
        for (CallbackContainer cc : c_globalObjects.values()) {
            bridge.registerObject((Object)cc.m_id, (Object)cc.m_object);
        }
    }

    private static class CallbackContainer {
        String m_id;
        RPCCallable m_object;
        Permission m_permission;

        private CallbackContainer() {
        }
    }

    static class WikiJSONAccessor
    implements InvocationCallback {
        private static final long serialVersionUID = 1L;
        private static final Logger log = LoggerFactory.getLogger(WikiJSONAccessor.class);

        public void postInvoke(Object context, Object instance, Method method, Object result) throws Exception {
        }

        public void preInvoke(Object context, Object instance, Method method, Object[] arguments) throws Exception {
            if (context instanceof HttpServletRequest) {
                boolean canDo = false;
                HttpServletRequest req = (HttpServletRequest)context;
                WikiEngine e = WikiEngine.getInstance(req.getSession().getServletContext(), null);
                for (CallbackContainer cc : c_globalObjects.values()) {
                    if (cc.m_object != instance) continue;
                    canDo = e.getAuthorizationManager().checkPermission(WikiSession.getWikiSession(e, req), cc.m_permission);
                    break;
                }
                if (canDo) {
                    return;
                }
            }
            log.debug("Failed JSON permission check: " + instance, new Object[0]);
            throw new WikiSecurityException("No permission to access this AJAX method!");
        }

        public void postInvoke(Object arg0, Object arg1, AccessibleObject arg2, Object arg3) throws Exception {
        }

        public void preInvoke(Object arg0, Object arg1, AccessibleObject arg2, Object[] arg3) throws Exception {
        }
    }
}

