/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.rpc.atom;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.WikiException;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.content.PageAlreadyExistsException;
import org.apache.wiki.content.PageNotFoundException;
import org.apache.wiki.content.WikiPath;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.plugin.WeblogEntryPlugin;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.ui.stripes.WikiActionBeanContext;
import org.apache.wiki.util.BlogUtil;
import org.apache.wiki.util.TextUtil;
import org.intabulas.sandler.Sandler;
import org.intabulas.sandler.SyndicationFactory;
import org.intabulas.sandler.elements.Content;
import org.intabulas.sandler.elements.Entry;
import org.intabulas.sandler.elements.Feed;
import org.intabulas.sandler.elements.Link;
import org.intabulas.sandler.elements.Person;
import org.intabulas.sandler.elements.impl.LinkImpl;
import org.intabulas.sandler.exceptions.FeedMarshallException;

public class AtomAPIServlet
extends HttpServlet {
    static final Logger log = LoggerFactory.getLogger(AtomAPIServlet.class);
    private static final long serialVersionUID = 0L;
    private WikiEngine m_engine;

    public void init(ServletConfig config) throws ServletException {
        this.m_engine = WikiEngine.getInstance(config);
    }

    private String getPageName(HttpServletRequest request) {
        String name = request.getPathInfo();
        if (name == null || name.length() <= 1) {
            return null;
        }
        if (name.charAt(0) == '/') {
            name = name.substring(1);
        }
        name = TextUtil.urlDecodeUTF8(name);
        return name;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        log.debug("Received POST to AtomAPIServlet", new Object[0]);
        try {
            WikiPage entryPage;
            String blogid = this.getPageName(request);
            try {
                this.m_engine.getPage(blogid);
            }
            catch (PageNotFoundException e) {
                throw new ServletException("Page " + blogid + " does not exist, cannot add blog post.");
            }
            Entry entry = Sandler.unmarshallEntry((InputStream)request.getInputStream());
            Content title = entry.getTitle();
            Content content = entry.getContent(0);
            Person author = entry.getAuthor();
            WeblogEntryPlugin plugin = new WeblogEntryPlugin();
            String pageName = plugin.getNewEntryPage(this.m_engine, blogid);
            String username = author.getName();
            try {
                entryPage = this.m_engine.createPage(WikiPath.valueOf(pageName));
            }
            catch (PageAlreadyExistsException e) {
                throw new ServletException(e.getMessage());
            }
            entryPage.setAuthor(username);
            WikiActionBeanContext context = this.m_engine.getWikiContextFactory().newViewContext(request, response, entryPage);
            StringBuffer text = new StringBuffer();
            text.append("!" + title.getBody());
            text.append("\n\n");
            text.append(content.getBody());
            log.debug("Writing entry: " + text, new Object[0]);
            this.m_engine.saveText(context, text.toString());
        }
        catch (FeedMarshallException e) {
            log.error("Received faulty Atom entry", e);
            throw new ServletException("Faulty Atom entry", (Throwable)e);
        }
        catch (IOException e) {
            log.error("I/O exception", e);
            throw new ServletException("Could not get body of request", (Throwable)e);
        }
        catch (WikiException e) {
            log.error("Provider exception while posting", e);
            throw new ServletException("JSPWiki cannot save the entry", (Throwable)e);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        log.debug("Received HTTP GET to AtomAPIServlet", new Object[0]);
        String blogid = this.getPageName(request);
        log.debug("Requested page " + blogid, new Object[0]);
        try {
            if (blogid == null) {
                Feed feed = this.listBlogs();
                response.setContentType("application/x.atom+xml; charset=UTF-8");
                response.getWriter().println(Sandler.marshallFeed((Feed)feed));
                response.getWriter().flush();
            } else {
                Entry entry = this.getBlogEntry(blogid);
                response.setContentType("application/x.atom+xml; charset=UTF-8");
                response.getWriter().println(Sandler.marshallEntry((Entry)entry));
                response.getWriter().flush();
            }
        }
        catch (Exception e) {
            log.error("Unable to generate response", e);
            throw new ServletException("Internal problem - whack Janne on the head to get a better error report", (Throwable)e);
        }
    }

    private Entry getBlogEntry(String entryid) throws Exception {
        WikiPage page = this.m_engine.getPage(entryid);
        WikiPage firstVersion = this.m_engine.getPage(entryid, 1);
        Entry entry = SyndicationFactory.newSyndicationEntry();
        String pageText = this.m_engine.getText(page.getName());
        String title = "";
        int firstLine = pageText.indexOf(10);
        if (firstLine > 0) {
            title = pageText.substring(0, firstLine);
        }
        if (title.trim().length() == 0) {
            title = page.getName();
        }
        while (title.startsWith("!")) {
            title = title.substring(1);
        }
        entry.setTitle(title);
        entry.setCreated(firstVersion.getLastModified());
        entry.setModified(page.getLastModified());
        entry.setAuthor(SyndicationFactory.createPerson((String)page.getAuthor(), null, null));
        entry.addContent(SyndicationFactory.createEscapedContent((String)pageText));
        return entry;
    }

    private Feed listBlogs() throws ProviderException, IOException {
        List<WikiPage> pages = this.m_engine.getContentManager().getAllPages(null);
        Feed feed = SyndicationFactory.newSyndicationFeed();
        feed.setTitle("List of blogs at this site");
        feed.setModified(new Date());
        for (WikiPage p : pages) {
            log.debug(String.valueOf(p.getName()) + " = " + p.getAttribute("weblogplugin.isweblog"), new Object[0]);
            if (!"true".equals(p.getAttribute("weblogplugin.isweblog"))) continue;
            String encodedName = TextUtil.urlEncodeUTF8(p.getName());
            WikiActionBeanContext context = this.m_engine.getWikiContextFactory().newViewContext(p);
            String title = TextUtil.replaceEntities(BlogUtil.getSiteName(context));
            Link postlink = this.createLink("service.post", String.valueOf(this.m_engine.getBaseURL()) + "atom/" + encodedName, title);
            Link editlink = this.createLink("service.edit", String.valueOf(this.m_engine.getBaseURL()) + "atom/" + encodedName, title);
            Link feedlink = this.createLink("service.feed", String.valueOf(this.m_engine.getBaseURL()) + "atom.jsp?page=" + encodedName, title);
            feed.addLink(postlink);
            feed.addLink(feedlink);
            feed.addLink(editlink);
        }
        return feed;
    }

    private Link createLink(String rel, String href, String title) {
        LinkImpl link = new LinkImpl();
        link.setRelationship(rel);
        link.setTitle(title);
        link.setType("application/x.atom+xml");
        link.setHref(href);
        return link;
    }

    public void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        log.debug("Received HTTP DELETE", new Object[0]);
    }

    public void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        log.debug("Received HTTP PUT", new Object[0]);
    }
}

