/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.render;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.wiki.WikiContext;
import org.apache.wiki.htmltowiki.XHtmlToWikiConfig;
import org.apache.wiki.parser.WikiDocument;
import org.apache.wiki.render.WikiRenderer;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class WysiwygEditingRenderer
extends WikiRenderer {
    private static final String A_ELEMENT = "a";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String HREF_ATTRIBUTE = "href";
    private static final String TITLE_ATTRIBUTE = "title";
    private static final String EDITPAGE = "createpage";
    private static final String WIKIPAGE = "wikipage";
    private static final String LINEBREAK = "\n";
    private static final String LINKS_TRANSLATION = "$1#$2";
    private static final String LINKS_SOURCE = "(.+)#section-.+-(.+)";

    public WysiwygEditingRenderer(WikiContext context, WikiDocument doc) {
        super(context, doc);
    }

    private void processChildren(Element baseElement) {
        for (Object childElement : baseElement.getChildren()) {
            if (!(childElement instanceof Element)) continue;
            Element element = (Element)childElement;
            String elementName = element.getName().toLowerCase();
            Attribute classAttr = element.getAttribute(CLASS_ATTRIBUTE);
            if (elementName.equals(A_ELEMENT) && classAttr != null) {
                String classValue = classAttr.getValue();
                Attribute hrefAttr = element.getAttribute(HREF_ATTRIBUTE);
                XHtmlToWikiConfig wikiConfig = new XHtmlToWikiConfig(this.m_context);
                String wikiPageLinkUrl = wikiConfig.getWikiJspPage();
                String editPageLinkUrl = wikiConfig.getEditJspPage();
                if (classValue.equals(WIKIPAGE) || hrefAttr != null && hrefAttr.getValue().startsWith(wikiPageLinkUrl)) {
                    String newHref = hrefAttr.getValue().substring(wikiPageLinkUrl.length());
                    newHref = this.m_context.getEngine().decodeName(newHref);
                    hrefAttr.setValue(newHref.replaceFirst(LINKS_SOURCE, LINKS_TRANSLATION));
                } else if (hrefAttr != null && (classValue.equals(EDITPAGE) || hrefAttr.getValue().startsWith(editPageLinkUrl))) {
                    Attribute titleAttr = element.getAttribute(TITLE_ATTRIBUTE);
                    if (titleAttr != null) {
                        titleAttr.detach();
                    }
                    String newHref = hrefAttr.getValue().substring(editPageLinkUrl.length());
                    newHref = this.m_context.getEngine().decodeName(newHref);
                    hrefAttr.setValue(newHref);
                }
            }
            this.processChildren(element);
        }
    }

    public String getString() throws IOException {
        Element rootElement = this.m_document.getRootElement();
        this.processChildren(rootElement);
        this.m_document.setContext(this.m_context);
        XMLOutputter output = new XMLOutputter();
        StringWriter out = new StringWriter();
        Format fmt = Format.getRawFormat();
        fmt.setExpandEmptyElements(false);
        fmt.setLineSeparator(LINEBREAK);
        output.setFormat(fmt);
        output.outputElementContent(this.m_document.getRootElement(), (Writer)out);
        return out.toString();
    }
}

