/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.render;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Properties;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.WikiException;
import org.apache.wiki.content.WikiPath;
import org.apache.wiki.event.WikiEvent;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.event.WikiEventUtils;
import org.apache.wiki.event.WikiPageEvent;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.modules.InternalModule;
import org.apache.wiki.parser.JSPWikiMarkupParser;
import org.apache.wiki.parser.MarkupParser;
import org.apache.wiki.parser.WikiDocument;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.render.WikiRenderer;
import org.apache.wiki.render.XHTMLRenderer;
import org.apache.wiki.util.TextUtil;

public class RenderingManager
implements WikiEventListener,
InternalModule {
    private static Logger log = LoggerFactory.getLogger(RenderingManager.class);
    private int m_cacheExpiryPeriod = 86400;
    private WikiEngine m_engine;
    public static final String PROP_CACHESIZE = "jspwiki.renderingManager.capacity";
    private static final int DEFAULT_CACHESIZE = 1000;
    private static final String VERSION_DELIMITER = "::";
    private static final String PROP_RENDERER = "jspwiki.renderingManager.renderer";
    public static final String DEFAULT_RENDERER = XHTMLRenderer.class.getName();
    public static final String CACHE_NAME = "jspwiki.renderingCache";
    private CacheManager m_cacheManager = CacheManager.getInstance();
    private Cache m_documentCache;
    private Constructor<?> m_rendererConstructor;
    public static final String WYSIWYG_EDITOR_MODE = "WYSIWYG_EDITOR_MODE";
    public static final String VAR_EXECUTE_PLUGINS = "_PluginContent.execute";

    public void initialize(WikiEngine engine, Properties properties) throws WikiException {
        this.m_engine = engine;
        int cacheSize = TextUtil.getIntegerProperty(properties, PROP_CACHESIZE, 1000);
        Cache c = this.m_cacheManager.getCache(CACHE_NAME);
        if (c == null && cacheSize > 0) {
            c = new Cache(CACHE_NAME, cacheSize, false, false, (long)this.m_cacheExpiryPeriod, (long)this.m_cacheExpiryPeriod);
            this.m_cacheManager.addCache(c);
        } else {
            log.info("RenderingManager caching is disabled.", new Object[0]);
        }
        this.m_documentCache = this.m_cacheManager.getCache(CACHE_NAME);
        String renderImplName = properties.getProperty(PROP_RENDERER);
        if (renderImplName == null) {
            renderImplName = DEFAULT_RENDERER;
        }
        Class[] rendererParams = new Class[]{WikiContext.class, WikiDocument.class};
        try {
            Class<?> cc = Class.forName(renderImplName);
            this.m_rendererConstructor = cc.getConstructor(rendererParams);
        }
        catch (ClassNotFoundException e) {
            log.error("Unable to find WikiRenderer implementation " + renderImplName, new Object[0]);
        }
        catch (SecurityException e) {
            log.error("Unable to access the WikiRenderer(WikiContext,WikiDocument) constructor for " + renderImplName, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            log.error("Unable to locate the WikiRenderer(WikiContext,WikiDocument) constructor for " + renderImplName, new Object[0]);
        }
        if (this.m_rendererConstructor == null) {
            throw new WikiException("Failed to get WikiRenderer '" + renderImplName + "'.");
        }
        log.info("Rendering content with " + renderImplName + ".", new Object[0]);
        WikiEventUtils.addWikiEventListener(this.m_engine, 21, this);
    }

    public MarkupParser getParser(WikiContext context, String pagedata) {
        JSPWikiMarkupParser parser = new JSPWikiMarkupParser(context, new StringReader(pagedata));
        return parser;
    }

    protected WikiDocument getRenderedDocument(WikiContext context, String pagedata) throws IOException {
        WikiDocument doc;
        String pageid = String.valueOf(context.getRealPage().getPath().toString().toLowerCase()) + VERSION_DELIMITER + context.getRealPage().getVersion();
        if (this.m_documentCache != null) {
            Element e = this.m_documentCache.get((Serializable)((Object)pageid));
            if (e != null) {
                doc = (WikiDocument)((Object)e.getObjectValue());
                if (pagedata.equals(doc.getPageData())) {
                    if (log.isDebugEnabled()) {
                        log.debug("Using cached HTML for page " + pageid, new Object[0]);
                    }
                    return doc;
                }
            } else if (log.isDebugEnabled()) {
                log.debug("Re-rendering and storing " + pageid, new Object[0]);
            }
        }
        try {
            MarkupParser parser = this.getParser(context, pagedata);
            doc = parser.parse();
            doc.setPageData(pagedata);
            if (this.m_documentCache != null) {
                this.m_documentCache.put(new Element((Serializable)((Object)pageid), (Serializable)((Object)doc)));
            }
            return doc;
        }
        catch (IOException ex) {
            log.error("Unable to parse", ex);
            return null;
        }
    }

    public String getHTML(WikiContext context, WikiDocument doc) throws IOException {
        WikiRenderer rend = this.getRenderer(context, doc);
        return rend.getString();
    }

    public WikiRenderer getRenderer(WikiContext context, WikiDocument doc) {
        Object[] params = new Object[]{context, doc};
        WikiRenderer rval = null;
        try {
            rval = (WikiRenderer)this.m_rendererConstructor.newInstance(params);
        }
        catch (Exception e) {
            log.error("Unable to create WikiRenderer", e);
        }
        return rval;
    }

    public String getHTML(WikiContext context, String pagedata) {
        try {
            WikiDocument doc = this.getRenderedDocument(context, pagedata);
            return this.getHTML(context, doc);
        }
        catch (IOException e) {
            log.error("Unable to parse", e);
            return null;
        }
    }

    private void flushCache(String key) {
        List keys = this.m_documentCache.getKeys();
        for (String k : keys) {
            if (!k.startsWith(key)) continue;
            this.m_documentCache.remove((Serializable)((Object)k));
        }
    }

    public void actionPerformed(WikiEvent event) {
        if (event instanceof WikiPageEvent && event.getType() == 21 && this.m_documentCache != null) {
            WikiPath pageName = ((WikiPageEvent)event).getPath();
            this.flushCache(pageName.toString());
            try {
                List<WikiPath> referringPages = this.m_engine.getReferenceManager().getReferredBy(pageName);
                if (referringPages != null) {
                    for (WikiPath path : referringPages) {
                        if (log.isDebugEnabled()) {
                            log.debug("Flushing " + path, new Object[0]);
                        }
                        this.flushCache(path.toString());
                    }
                }
            }
            catch (ProviderException providerException) {
                // empty catch block
            }
        }
    }
}

