/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.render;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.wiki.WikiContext;
import org.apache.wiki.parser.PluginContent;
import org.apache.wiki.parser.WikiDocument;
import org.apache.wiki.render.WikiRenderer;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;

public class CreoleRenderer
extends WikiRenderer {
    private static final String IMG_START = "{{";
    private static final String IMG_END = "}}";
    private static final String PLUGIN_START = "<<";
    private static final String PLUGIN_END = ">>";
    private static final String HREF_START = "[[";
    private static final String HREF_DELIMITER = "|";
    private static final String HREF_END = "]]";
    private static final String PRE_START = "{{{";
    private static final String PRE_END = "}}}";
    private static final String PLUGIN_IMAGE = "Image";
    private static final String PARAM_SRC = "src";
    private static final String HREF_ATTRIBUTE = "href";
    private static final String ONE_SPACE = " ";
    private static final String EMPTY_STRING = "";
    private static final String LINEBREAK = "\n";
    private static final String LI = "li";
    private static final String UL = "ul";
    private static final String OL = "ol";
    private static final String P = "p";
    private static final String A = "a";
    private static final String PRE = "pre";
    private static final String[] ELEMENTS = new String[]{"i", "//", "//", "b", "**", "**", "h2", "== ", " ==", "h3", "=== ", " ===", "h4", "==== ", " ====", "hr", "----", "", "tt", "<<{{>>", "<<}}>>"};
    private int m_listCount = 0;
    private char m_listChar = (char)120;
    private List<PluginContent> m_plugins = new ArrayList<PluginContent>();

    public CreoleRenderer(WikiContext ctx, WikiDocument doc) {
        super(ctx, doc);
    }

    private void renderElement(Element ce, StringBuilder sb) {
        String endEl = EMPTY_STRING;
        int i = 0;
        while (i < ELEMENTS.length) {
            if (ELEMENTS[i].equals(ce.getName())) {
                sb.append(ELEMENTS[i + 1]);
                endEl = ELEMENTS[i + 2];
            }
            i += 3;
        }
        if (UL.equals(ce.getName())) {
            ++this.m_listCount;
            this.m_listChar = (char)42;
        } else if (OL.equals(ce.getName())) {
            ++this.m_listCount;
            this.m_listChar = (char)35;
        } else if (LI.equals(ce.getName())) {
            i = 0;
            while (i < this.m_listCount) {
                sb.append(this.m_listChar);
                ++i;
            }
            sb.append(ONE_SPACE);
        } else {
            if (A.equals(ce.getName())) {
                String text;
                String href = ce.getAttributeValue(HREF_ATTRIBUTE);
                if (href.equals(text = ce.getText())) {
                    sb.append(HREF_START + href + HREF_END);
                } else {
                    sb.append(HREF_START + href + HREF_DELIMITER + text + HREF_END);
                }
                return;
            }
            if (PRE.equals(ce.getName())) {
                sb.append(PRE_START);
                sb.append(ce.getText());
                sb.append(PRE_END);
                return;
            }
        }
        for (Content c : ce.getContent()) {
            if (c instanceof PluginContent) {
                PluginContent pc = (PluginContent)c;
                if (pc.getPluginName().equals(PLUGIN_IMAGE)) {
                    sb.append(IMG_START + pc.getParameter(PARAM_SRC) + IMG_END);
                    continue;
                }
                this.m_plugins.add(pc);
                sb.append(PLUGIN_START + pc.getPluginName() + ONE_SPACE + this.m_plugins.size() + PLUGIN_END);
                continue;
            }
            if (c instanceof Text) {
                sb.append(((Text)c).getText());
                continue;
            }
            if (!(c instanceof Element)) continue;
            this.renderElement((Element)c, sb);
        }
        if (UL.equals(ce.getName()) || OL.equals(ce.getName())) {
            --this.m_listCount;
        } else if (P.equals(ce.getName())) {
            sb.append(LINEBREAK);
        }
        sb.append(endEl);
    }

    public String getString() throws IOException {
        StringBuilder sb = new StringBuilder(1000);
        Element ce = this.m_document.getRootElement();
        this.renderElement(ce, sb);
        return sb.toString();
    }
}

