/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.render;

import java.io.IOException;
import java.util.List;
import org.apache.wiki.WikiContext;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.parser.WikiDocument;
import org.apache.wiki.render.WikiRenderer;
import org.jdom.JDOMException;
import org.jdom.Text;
import org.jdom.xpath.XPath;

public class CleanTextRenderer
extends WikiRenderer {
    private static final String ALL_TEXT_NODES = "//text()";
    protected static final Logger log = LoggerFactory.getLogger(CleanTextRenderer.class);

    public CleanTextRenderer(WikiContext context, WikiDocument doc) {
        super(context, doc);
    }

    public String getString() throws IOException {
        StringBuilder sb = new StringBuilder();
        try {
            XPath xp = XPath.newInstance((String)ALL_TEXT_NODES);
            List nodes = xp.selectNodes((Object)this.m_document.getDocument());
            for (Object el : nodes) {
                if (!(el instanceof Text)) continue;
                sb.append(((Text)el).getValue());
            }
        }
        catch (JDOMException e) {
            log.error("Could not parse XPATH expression", new Object[0]);
            throw new IOException(e.getMessage());
        }
        return sb.toString();
    }
}

