/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.preferences;

import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.validation.TypeConverter;
import net.sourceforge.stripes.validation.TypeConverterFactory;
import net.sourceforge.stripes.validation.ValidationError;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.i18n.InternationalizationManager;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.ui.TemplateManager;
import org.apache.wiki.ui.stripes.WikiActionBeanContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Preferences
implements Map<String, Object> {
    public static final String PREFS_TIME_FORMAT = "TimeFormat";
    public static final String PREFS_TIME_ZONE = "TimeZone";
    public static final String PREFS_ORIENTATION = "Orientation";
    public static final String PREFS_SECTION_EDITING = "SectionEditing";
    public static final String PREFS_EDITOR = "Editor";
    public static final String PREFS_LOCALE = "Locale";
    public static final String PREFS_SKIN = "Skin";
    public static final Map<Locale, String> AVAILABLE_LOCALES;
    private final Collection<ValidationError> m_errors;
    public static final List<TimeZone> AVAILABLE_TIME_ZONES;
    private static final Map<String, Class<? extends Object>> TYPE_CONVERTERS;
    public static final String TIMEFORMATPROPERTIES = "jspwiki.defaultprefs.timeformat.";
    private static final String SESSIONPREFS = "prefs";
    private static final long serialVersionUID = 2L;
    private static Logger log;
    private final WikiEngine m_engine;
    private final Map<String, Object> m_prefs = new HashMap<String, Object>();

    static {
        String[] ids;
        log = LoggerFactory.getLogger(Preferences.class);
        ArrayList<TimeZone> zones = new ArrayList<TimeZone>();
        String[] stringArray = ids = new String[]{"Pacific/Midway", "Pacific/Honolulu", "America/Anchorage", "America/Los_Angeles", "US/Mountain", "America/Chicago", "America/New_York", "America/Caracas", "Brazil/East", "Atlantic/South_Georgia", "Atlantic/Cape_Verde", "Etc/Greenwich", "Europe/Rome", "ART", "EAT", "Asia/Dubai", "IST", "BST", "VST", "CTT", "JST", "Australia/Sydney", "SST", "NZ", "Pacific/Tongatapu", "Pacific/Kiritimati"};
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            TimeZone zone = TimeZone.getTimeZone(id);
            zones.add(zone);
            ++n2;
        }
        AVAILABLE_TIME_ZONES = Collections.unmodifiableList(zones);
        Locale[] locales = Locale.getAvailableLocales();
        HashMap<Locale, String> foundLocales = new HashMap<Locale, String>();
        Locale[] localeArray = locales;
        int n3 = locales.length;
        int n4 = 0;
        while (n4 < n3) {
            Locale locale = localeArray[n4];
            URL url = TemplateManager.class.getClassLoader().getResource("CoreResources_" + locale.toString() + ".properties");
            if (url != null) {
                foundLocales.put(locale, locale.getDisplayName(locale));
            }
            ++n4;
        }
        AVAILABLE_LOCALES = Collections.unmodifiableMap(foundLocales);
        TYPE_CONVERTERS = new HashMap<String, Class<? extends Object>>();
        TYPE_CONVERTERS.put(PREFS_LOCALE, Locale.class);
        TYPE_CONVERTERS.put(PREFS_ORIENTATION, Orientation.class);
        TYPE_CONVERTERS.put(PREFS_SECTION_EDITING, Boolean.class);
        TYPE_CONVERTERS.put(PREFS_TIME_ZONE, TimeZone.class);
    }

    public static void main(String[] args) {
        String[] ids = TimeZone.getAvailableIDs();
        TreeMap tzs = new TreeMap();
        long now = System.currentTimeMillis();
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            TimeZone tz = TimeZone.getTimeZone(id);
            int offset = tz.getOffset(now) / 60000;
            HashSet<TimeZone> tzsForOffset = (HashSet<TimeZone>)tzs.get(offset);
            if (tzsForOffset == null) {
                tzsForOffset = new HashSet<TimeZone>();
                tzs.put(offset, tzsForOffset);
            }
            if (tzsForOffset.size() < 10) {
                tzsForOffset.add(tz);
            }
            ++n2;
        }
        System.out.println("Foo!");
        for (Map.Entry entry : tzs.entrySet()) {
            System.out.print(entry.getKey() + ": ");
            for (TimeZone tz : (Set)entry.getValue()) {
                String city = tz.getID();
                int firstSlash = city.indexOf("/");
                if (firstSlash >= 0) {
                    city = city.substring(firstSlash + 1);
                }
                city = city.replace('_', ' ');
                System.out.print(String.valueOf(city) + ", ");
            }
            System.out.println(".");
        }
    }

    public static Preferences getPreferences(HttpServletRequest request) {
        Preferences prefs = (Preferences)request.getSession().getAttribute(SESSIONPREFS);
        if (prefs == null) {
            WikiEngine engine = WikiEngine.getInstance(request.getSession().getServletContext(), null);
            prefs = new Preferences(engine);
            prefs.initialize(request);
            request.getSession().setAttribute(SESSIONPREFS, (Object)prefs);
        }
        return prefs;
    }

    private Preferences(WikiEngine engine) {
        this.m_engine = engine;
        this.m_errors = new ArrayList<ValidationError>();
    }

    @Override
    public void clear() {
        this.m_prefs.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.m_prefs.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.m_prefs.containsKey(value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.m_prefs.entrySet();
    }

    @Override
    public Object get(Object key) {
        if ("availableLocales".equals(key)) {
            return AVAILABLE_LOCALES;
        }
        if ("availableSkins".equals(key)) {
            return this.m_engine.getTemplateManager().listSkins();
        }
        if ("availableTimeFormats".equals(key)) {
            return this.availableTimeFormats();
        }
        if ("availableTimeZones".equals(key)) {
            return AVAILABLE_TIME_ZONES;
        }
        return this.m_prefs.get(key);
    }

    public SimpleDateFormat getDateFormat(TimeFormat tf) {
        Locale locale;
        String prefDateFormat;
        InternationalizationManager i18n = this.m_engine.getInternationalizationManager();
        log.debug("Checking for preferences...", new Object[0]);
        switch (tf) {
            case DATETIME: {
                prefDateFormat = (String)this.get(PREFS_TIME_FORMAT);
                log.debug("Preferences fmt = " + prefDateFormat, new Object[0]);
                if (prefDateFormat != null) break;
                locale = (Locale)this.get(PREFS_LOCALE);
                prefDateFormat = i18n.get("CoreResources", locale, "common.datetimeformat");
                log.debug("Using locale-format = " + prefDateFormat, new Object[0]);
                break;
            }
            case TIME: {
                prefDateFormat = i18n.get("common.timeformat");
                break;
            }
            case DATE: {
                prefDateFormat = i18n.get("common.dateformat");
                break;
            }
            default: {
                throw new InternalWikiException("Got a TimeFormat for which we have no value!");
            }
        }
        try {
            locale = (Locale)this.get(PREFS_LOCALE);
            SimpleDateFormat fmt = new SimpleDateFormat(prefDateFormat, locale);
            TimeZone tz = (TimeZone)this.get(PREFS_TIME_ZONE);
            if (tz != null) {
                fmt.setTimeZone(tz);
            }
            return fmt;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.m_prefs.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.m_prefs.keySet();
    }

    @Override
    public Object put(String key, Object value) {
        return this.m_prefs.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        this.m_prefs.putAll(m);
    }

    @Override
    public Object remove(Object key) {
        return this.m_prefs.remove(key);
    }

    public void save(WikiActionBeanContext context) {
        HttpServletResponse response = context.getResponse();
        for (Map.Entry<String, Object> item : this.m_prefs.entrySet()) {
            String key = item.getKey();
            Object value = item.getValue();
            if (key == null || value == null) continue;
            String stringValue = null;
            stringValue = value instanceof Enum ? ((Enum)value).name() : (value instanceof Boolean ? Boolean.toString((Boolean)value) : (value instanceof TimeZone ? ((TimeZone)value).getID() : value.toString()));
            Cookie cookie = new Cookie(key, stringValue);
            response.addCookie(cookie);
        }
    }

    @Override
    public int size() {
        return this.m_prefs.size();
    }

    @Override
    public Collection<Object> values() {
        return this.m_prefs.values();
    }

    private Map<String, String> availableTimeFormats() {
        Properties props = this.m_engine.getWikiProperties();
        ArrayList<String> timeFormats = new ArrayList<String>(40);
        LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith(TIMEFORMATPROPERTIES)) continue;
            timeFormats.add(name);
        }
        if (timeFormats.size() == 0) {
            timeFormats.add("dd-MMM-yy");
            timeFormats.add("d-MMM-yyyy");
            timeFormats.add("EEE, dd-MMM-yyyy, zzzz");
        } else {
            Collections.sort(timeFormats);
            int i = 0;
            while (i < timeFormats.size()) {
                timeFormats.set(i, props.getProperty((String)timeFormats.get(i)));
                ++i;
            }
        }
        TimeZone timeZone = (TimeZone)this.m_prefs.get(PREFS_TIME_ZONE);
        Date d = new Date();
        try {
            SimpleDateFormat format = this.getDateFormat(TimeFormat.DATETIME);
            format.setTimeZone(timeZone);
            int i = 0;
            while (i < timeFormats.size()) {
                try {
                    String f = (String)timeFormats.get(i);
                    format.applyPattern(f);
                    resultMap.put(f, format.format(d));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                ++i;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return resultMap;
    }

    private Object coerceCookieValue(HttpServletRequest request, TypeConverterFactory converters, String cookieName, String defaultValue) {
        String cookieValue = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            Cookie[] cookieArray = request.getCookies();
            int n = cookieArray.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                if (cookieName.equals(cookie.getName())) {
                    cookieValue = cookie.getValue();
                    break;
                }
                ++n2;
            }
        }
        if (cookieValue == null) {
            cookieValue = defaultValue;
        }
        Locale locale = (Locale)this.get(PREFS_LOCALE);
        Class<? extends Object> targetClass = TYPE_CONVERTERS.get(cookieName);
        if (targetClass == null) {
            targetClass = String.class;
        }
        Object value = null;
        try {
            TypeConverter converter = converters.getTypeConverter(targetClass, locale);
            converter.setLocale(locale);
            value = converter.convert(cookieValue, targetClass, this.m_errors);
        }
        catch (Exception e) {
            log.error("Could not coerce cookie " + cookieName + "\"", new Object[0]);
        }
        return value == null ? defaultValue : value;
    }

    private void initialize(HttpServletRequest request) {
        Properties props = this.m_engine.getWikiProperties();
        Locale locale = request.getLocale();
        this.m_prefs.put(PREFS_LOCALE, locale);
        Configuration stripesConfig = StripesFilter.getConfiguration();
        if (stripesConfig == null) {
            throw new InternalWikiException("Cannot obtain Stripes configuration. This might happen if called outside a JSP.");
        }
        TypeConverterFactory converters = stripesConfig.getTypeConverterFactory();
        this.m_errors.clear();
        String defaultValue = props.getProperty("jspwiki.defaultprefs.template.editor", "plain");
        Object value = this.coerceCookieValue(request, converters, PREFS_EDITOR, defaultValue);
        this.m_prefs.put(PREFS_EDITOR, value);
        defaultValue = props.getProperty("jspwiki.defaultprefs.template.orientation", Orientation.LEFT.name());
        value = this.coerceCookieValue(request, converters, PREFS_ORIENTATION, defaultValue);
        this.m_prefs.put(PREFS_ORIENTATION, value);
        defaultValue = props.getProperty("jspwiki.defaultprefs.template.sectionediting", "false");
        value = this.coerceCookieValue(request, converters, PREFS_SECTION_EDITING, defaultValue);
        this.m_prefs.put(PREFS_SECTION_EDITING, value);
        defaultValue = props.getProperty("jspwiki.defaultprefs.template.skinname", "PlainVanilla");
        value = this.coerceCookieValue(request, converters, PREFS_SKIN, defaultValue);
        this.m_prefs.put(PREFS_SKIN, value);
        defaultValue = props.getProperty("jspwiki.defaultprefs.template.dateformat", this.m_engine.getInternationalizationManager().get("CoreResources", locale, "common.datetimeformat"));
        value = this.coerceCookieValue(request, converters, PREFS_TIME_FORMAT, defaultValue);
        this.m_prefs.put(PREFS_TIME_FORMAT, value);
        defaultValue = props.getProperty("jspwiki.defaultprefs.template.timezone", TimeZone.getDefault().getID());
        value = this.coerceCookieValue(request, converters, PREFS_TIME_ZONE, defaultValue);
        for (TimeZone timeZone : AVAILABLE_TIME_ZONES) {
            if (timeZone.getRawOffset() != ((TimeZone)value).getRawOffset()) continue;
            value = timeZone;
            break;
        }
        this.m_prefs.put(PREFS_TIME_ZONE, value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Orientation {
        LEFT,
        RIGHT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TimeFormat {
        TIME,
        DATE,
        DATETIME;

    }
}

