/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.PluginException;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.auth.AuthorizationManager;
import org.apache.wiki.auth.permissions.PagePermission;
import org.apache.wiki.content.ContentManager;
import org.apache.wiki.content.PageNotFoundException;
import org.apache.wiki.content.jcr.JCRWikiPage;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.parser.PluginContent;
import org.apache.wiki.plugin.ParserStagePlugin;
import org.apache.wiki.plugin.WikiPlugin;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.util.PageTimeComparator;
import org.apache.wiki.util.TextUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeblogPlugin
implements WikiPlugin,
ParserStagePlugin {
    private static Logger log = LoggerFactory.getLogger(WeblogPlugin.class);
    private static final Pattern HEADINGPATTERN = Pattern.compile("(<h[1-4][^>]*>)(.*)(</h[1-4]>)", 2);
    private static final int DEFAULT_DAYS = 7;
    private static final String DEFAULT_PAGEFORMAT = "%p_blogentry_";
    public static final String DEFAULT_DATEFORMAT = "ddMMyy";
    public static final String PARAM_STARTDATE = "startDate";
    public static final String PARAM_ENTRYFORMAT = "entryFormat";
    public static final String PARAM_DAYS = "days";
    public static final String PARAM_ALLOWCOMMENTS = "allowComments";
    public static final String PARAM_MAXENTRIES = "maxEntries";
    public static final String PARAM_PAGE = "page";
    public static final String ATTR_ISWEBLOG = "weblogplugin.isweblog";

    public static String makeEntryPage(String pageName, String date, String entryNum) {
        return String.valueOf(TextUtil.replaceString(DEFAULT_PAGEFORMAT, "%p", pageName)) + date + "_" + entryNum;
    }

    public static String makeEntryPage(String pageName) {
        return TextUtil.replaceString(DEFAULT_PAGEFORMAT, "%p", pageName);
    }

    public static String makeEntryPage(String pageName, String date) {
        return String.valueOf(TextUtil.replaceString(DEFAULT_PAGEFORMAT, "%p", pageName)) + date;
    }

    public String execute(WikiContext context, Map params) throws PluginException {
        SimpleDateFormat entryFormat;
        String days;
        int numDays = 7;
        WikiEngine engine = context.getEngine();
        AuthorizationManager mgr = engine.getAuthorizationManager();
        String startDay = null;
        boolean hasComments = false;
        String weblogName = (String)params.get(PARAM_PAGE);
        if (weblogName == null) {
            weblogName = context.getPage().getName();
        }
        if ((days = context.getHttpParameter("weblog.days")) == null) {
            days = (String)params.get(PARAM_DAYS);
        }
        if (params.get(PARAM_ENTRYFORMAT) == null) {
            Preferences prefs = Preferences.getPreferences(context.getHttpRequest());
            entryFormat = prefs.getDateFormat(Preferences.TimeFormat.DATETIME);
        } else {
            entryFormat = new SimpleDateFormat((String)params.get(PARAM_ENTRYFORMAT));
        }
        if (days != null) {
            numDays = days.equalsIgnoreCase("all") ? Integer.MAX_VALUE : TextUtil.parseIntParameter(days, 7);
        }
        if ((startDay = (String)params.get(PARAM_STARTDATE)) == null) {
            startDay = context.getHttpParameter("weblog.startDate");
        }
        if (TextUtil.isPositive((String)params.get(PARAM_ALLOWCOMMENTS))) {
            hasComments = true;
        }
        int maxEntries = TextUtil.parseIntParameter((String)params.get(PARAM_MAXENTRIES), Integer.MAX_VALUE);
        Calendar startTime = Calendar.getInstance();
        Calendar stopTime = Calendar.getInstance();
        if (startDay != null) {
            SimpleDateFormat fmt = new SimpleDateFormat(DEFAULT_DATEFORMAT);
            try {
                Date d = fmt.parse(startDay);
                startTime.setTime(d);
                stopTime.setTime(d);
            }
            catch (ParseException e) {
                return "Illegal time format: " + startDay;
            }
        }
        context.getPage().setAttribute(ATTR_ISWEBLOG, (Serializable)((Object)"true"));
        startTime.add(5, -numDays);
        startTime.set(10, 0);
        startTime.set(12, 0);
        startTime.set(13, 0);
        stopTime.set(10, 23);
        stopTime.set(12, 59);
        stopTime.set(13, 59);
        StringBuilder sb = new StringBuilder();
        try {
            SortedSet<WikiPage> blogEntries = this.findBlogEntriesSorted(engine.getContentManager(), weblogName, startTime.getTime(), stopTime.getTime());
            sb.append("<div class=\"weblog\">\n");
            Iterator i = blogEntries.iterator();
            while (i.hasNext() && maxEntries-- > 0) {
                WikiPage p = (WikiPage)i.next();
                if (!mgr.checkPermission(context.getWikiSession(), new PagePermission(p, "view"))) continue;
                this.addEntryHTML(context, entryFormat, hasComments, sb, p);
            }
            sb.append("</div>\n");
        }
        catch (ProviderException e) {
            log.error("Could not locate blog entries", e);
            throw new PluginException("Could not locate blog entries: " + e.getMessage());
        }
        return sb.toString();
    }

    private void addEntryHTML(WikiContext context, DateFormat entryFormat, boolean hasComments, StringBuilder buffer, WikiPage entry) throws ProviderException {
        WikiEngine engine = context.getEngine();
        buffer.append("<div class=\"weblogentry\">\n");
        buffer.append("<div class=\"weblogentryheading\">\n");
        Date entryDate = entry.getLastModified();
        buffer.append(entryFormat.format(entryDate));
        buffer.append("</div>\n");
        WikiContext entryCtx = (WikiContext)context.clone();
        entryCtx.setPage(entry);
        String html = "";
        try {
            html = engine.getHTML(entryCtx, engine.getPage(entry.getName()));
        }
        catch (PageNotFoundException pageNotFoundException) {
            // empty catch block
        }
        buffer.append("<div class=\"weblogentrytitle\">\n");
        Matcher matcher = HEADINGPATTERN.matcher(html);
        if (matcher.find()) {
            String title = matcher.group(2);
            html = matcher.replaceFirst("");
            buffer.append(title);
        } else {
            buffer.append(entry.getName());
        }
        buffer.append("</div>\n");
        buffer.append("<div class=\"weblogentrybody\">\n");
        buffer.append(html);
        buffer.append("</div>\n");
        buffer.append("<div class=\"weblogentryfooter\">\n");
        String author = entry.getAuthor();
        if (author != null) {
            if (engine.pageExists(author)) {
                author = "<a href=\"" + entryCtx.getURL(WikiContext.VIEW, author) + "\">" + engine.beautifyTitle(author) + "</a>";
            }
        } else {
            author = "AnonymousCoward";
        }
        buffer.append("By " + author + "&nbsp;&nbsp;");
        buffer.append("<a href=\"" + entryCtx.getURL(WikiContext.VIEW, entry.getName()) + "\">Permalink</a>");
        String commentPageName = TextUtil.replaceString(entry.getName(), "blogentry", "comments");
        if (hasComments) {
            int numComments = this.guessNumberOfComments(engine, commentPageName);
            buffer.append("&nbsp;&nbsp;");
            buffer.append("<a target=\"_blank\" href=\"" + entryCtx.getURL(WikiContext.COMMENT, commentPageName, "nc=" + numComments) + "\">Comments? (" + numComments + ")</a>");
        }
        buffer.append("</div>\n");
        buffer.append("</div>\n");
    }

    private int guessNumberOfComments(WikiEngine engine, String commentpage) throws ProviderException {
        String pagedata = engine.getPureText(commentpage, -1);
        if (pagedata == null || pagedata.trim().length() == 0) {
            return 0;
        }
        return TextUtil.countSections(pagedata);
    }

    public List<WikiPage> findBlogEntries(ContentManager mgr, String baseName, Date start, Date end) throws ProviderException {
        return (List)this.findBlogEntries(new ArrayList<WikiPage>(), mgr, baseName, start, end);
    }

    public SortedSet<WikiPage> findBlogEntriesSorted(ContentManager mgr, String baseName, Date start, Date end) throws ProviderException {
        return (SortedSet)this.findBlogEntries(new TreeSet<WikiPage>(PageTimeComparator.DEFAULT_PAGETIME_COMPARATOR), mgr, baseName, start, end);
    }

    public Collection<WikiPage> findBlogEntries(Collection<WikiPage> result, ContentManager mgr, String baseName, Date start, Date end) throws ProviderException {
        result.clear();
        List<WikiPage> everyone = mgr.getAllPages(null);
        baseName = WeblogPlugin.makeEntryPage(baseName);
        SimpleDateFormat fmt = new SimpleDateFormat(DEFAULT_DATEFORMAT);
        for (WikiPage p : everyone) {
            String pageName = p.getName();
            if (!pageName.startsWith(baseName)) continue;
            try {
                String creationDate;
                Date pageDay;
                int secondScore;
                int firstScore = pageName.indexOf(95, baseName.length() - 1);
                if (firstScore == -1 || firstScore + 1 >= pageName.length() || (secondScore = pageName.indexOf(95, firstScore + 1)) == -1 || (pageDay = fmt.parse(creationDate = pageName.substring(firstScore + 1, secondScore))) == null || !pageDay.after(start) || !pageDay.before(end)) continue;
                JCRWikiPage firstVersion = mgr.getPage(p.getPath(), 1);
                result.add(firstVersion);
            }
            catch (Exception e) {
                log.debug("Page name :" + pageName + " was suspected as a blog entry but it isn't because of parsing errors", e, new Object[0]);
            }
        }
        return result;
    }

    @Override
    public void executeParser(PluginContent element, WikiContext context, Map<String, Object> params) {
        context.getPage().setAttribute(ATTR_ISWEBLOG, (Serializable)((Object)"true"));
    }
}

