/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.PluginException;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.content.ContentManager;
import org.apache.wiki.content.PageAlreadyExistsException;
import org.apache.wiki.content.WikiPath;
import org.apache.wiki.content.lock.PageLock;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.plugin.WeblogPlugin;
import org.apache.wiki.plugin.WikiPlugin;
import org.apache.wiki.providers.ProviderException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeblogEntryPlugin
implements WikiPlugin {
    private static Logger log = LoggerFactory.getLogger(WeblogEntryPlugin.class);
    private static final int MAX_BLOG_ENTRIES = 10000;
    public static final String PARAM_ENTRYTEXT = "entrytext";
    public static final String PARAM_BLOGNAME = "page";

    public String getNewEntryPage(WikiEngine engine, String blogName) throws ProviderException {
        SimpleDateFormat fmt = new SimpleDateFormat("ddMMyy");
        String today = fmt.format(new Date());
        int entryNum = this.findFreeEntry(engine.getContentManager(), blogName, today);
        String blogPage = WeblogPlugin.makeEntryPage(blogName, today, "" + entryNum);
        return blogPage;
    }

    @Override
    public String execute(WikiContext context, Map<String, Object> params) throws PluginException {
        ResourceBundle rb = context.getBundle("plugin.PluginResources");
        String weblogName = (String)params.get(PARAM_BLOGNAME);
        if (weblogName == null) {
            weblogName = context.getPage().getName();
        }
        WikiEngine engine = context.getEngine();
        StringBuilder sb = new StringBuilder();
        String entryText = (String)params.get(PARAM_ENTRYTEXT);
        if (entryText == null) {
            entryText = rb.getString("weblogentryplugin.newentry");
        }
        String url = context.getURL("none", "NewBlogEntry.jsp", "page=" + engine.encodeName(weblogName));
        sb.append("<a href=\"" + url + "\">" + entryText + "</a>");
        return sb.toString();
    }

    private int findFreeEntry(ContentManager mgr, String baseName, String date) throws ProviderException {
        List<WikiPage> everyone = mgr.getAllPages(null);
        int max = 0;
        String startString = WeblogPlugin.makeEntryPage(baseName, date, "");
        for (WikiPage p : everyone) {
            if (!p.getName().startsWith(startString)) continue;
            try {
                String probableId = p.getName().substring(startString.length());
                int id = Integer.parseInt(probableId);
                if (id <= max) continue;
                max = id;
            }
            catch (NumberFormatException e) {
                log.debug("Was not a log entry: " + p.getName(), new Object[0]);
            }
        }
        int idx = max + 1;
        while (idx < 10000) {
            WikiPage page;
            String name = WeblogPlugin.makeEntryPage(baseName, date, Integer.toString(idx));
            try {
                page = mgr.getEngine().createPage(WikiPath.valueOf(name));
            }
            catch (PageAlreadyExistsException e) {
                throw new ProviderException(e.getMessage(), e);
            }
            PageLock lock = mgr.getCurrentLock(page);
            if (lock == null) break;
            ++idx;
        }
        return idx;
    }
}

