/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.PluginException;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.plugin.WeblogPlugin;
import org.apache.wiki.plugin.WikiPlugin;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.util.TextUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeblogArchivePlugin
implements WikiPlugin {
    private static Logger log = LoggerFactory.getLogger(WeblogArchivePlugin.class);
    public static final String PARAM_PAGE = "page";
    private SimpleDateFormat m_monthUrlFormat;

    @Override
    public String execute(WikiContext context, Map<String, Object> params) throws PluginException {
        WikiEngine engine = context.getEngine();
        String weblogName = (String)params.get(PARAM_PAGE);
        if (weblogName == null) {
            weblogName = context.getPage().getName();
        }
        this.m_monthUrlFormat = new SimpleDateFormat("'" + context.getURL(WikiContext.VIEW, weblogName, "weblog.startDate='ddMMyy'&amp;weblog.days=%d") + "'");
        StringBuilder sb = new StringBuilder();
        sb.append("<div class=\"weblogarchive\">\n");
        try {
            SortedSet<Calendar> months = this.collectMonths(engine, weblogName);
            int year = 0;
            sb.append("<ul>\n");
            if (months.size() > 0) {
                year = ((Calendar)months.iterator().next()).get(1);
                sb.append("<li class=\"archiveyear\">" + year + "</li>\n");
            }
            for (Calendar cal : months) {
                if (cal.get(1) != year) {
                    year = cal.get(1);
                    sb.append("<li class=\"archiveyear\">" + year + "</li>\n");
                }
                sb.append("  <li>");
                sb.append(this.getMonthLink(cal));
                sb.append("</li>\n");
            }
            sb.append("</ul>\n");
            sb.append("</div>\n");
        }
        catch (ProviderException ex) {
            log.info("Cannot get archive", ex, new Object[0]);
            sb.append("Cannot get archive: " + ex.getMessage());
        }
        return sb.toString();
    }

    private SortedSet<Calendar> collectMonths(WikiEngine engine, String page) throws ProviderException {
        ArchiveComparator comp = new ArchiveComparator();
        TreeSet<Calendar> res = new TreeSet<Calendar>(comp);
        WeblogPlugin pl = new WeblogPlugin();
        List<WikiPage> blogEntries = pl.findBlogEntries(engine.getContentManager(), page, new Date(0L), new Date());
        for (WikiPage p : blogEntries) {
            Date d = p.getLastModified();
            Calendar cal = Calendar.getInstance();
            cal.setTime(d);
            res.add(cal);
        }
        return res;
    }

    private String getMonthLink(Calendar day) {
        String result;
        SimpleDateFormat monthfmt = new SimpleDateFormat("MMMM");
        if (this.m_monthUrlFormat == null) {
            result = monthfmt.format(day.getTime());
        } else {
            Calendar cal = (Calendar)day.clone();
            int firstDay = cal.getActualMinimum(5);
            int lastDay = cal.getActualMaximum(5);
            cal.set(5, lastDay);
            String url = this.m_monthUrlFormat.format(cal.getTime());
            url = TextUtil.replaceString(url, "%d", Integer.toString(lastDay - firstDay + 1));
            result = "<a href=\"" + url + "\">" + monthfmt.format(cal.getTime()) + "</a>";
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArchiveComparator
    implements Comparator<Calendar> {
        private ArchiveComparator() {
        }

        @Override
        public int compare(Calendar a2, Calendar b2) {
            if (a2 == null || b2 == null) {
                throw new ClassCastException("Invalid calendar supplied for comparison.");
            }
            if (a2.get(1) == b2.get(1) && a2.get(2) == b2.get(2)) {
                return 0;
            }
            return b2.getTime().before(a2.getTime()) ? 1 : -1;
        }
    }
}

