/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.wiki.WikiContext;
import org.apache.wiki.api.PluginException;
import org.apache.wiki.content.ReferenceManager;
import org.apache.wiki.content.WikiPath;
import org.apache.wiki.plugin.AbstractFilteredPlugin;
import org.apache.wiki.util.TextUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnusedPagesPlugin
extends AbstractFilteredPlugin {
    public static final String PARAM_EXCLUDEATTS = "excludeattachments";

    @Override
    public String execute(WikiContext context, Map<String, Object> params) throws PluginException {
        List<WikiPath> links;
        ReferenceManager refmgr = context.getEngine().getReferenceManager();
        try {
            links = refmgr.findUnreferenced();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            throw new PluginException("Could not find unreferenced pages.", e);
        }
        String prop = (String)params.get(PARAM_EXCLUDEATTS);
        if (TextUtil.isPositive(prop)) {
            Iterator<WikiPath> iterator = links.iterator();
            while (iterator.hasNext()) {
                WikiPath link = iterator.next();
                if (link.getPath().indexOf("/") == -1) continue;
                iterator.remove();
            }
        }
        super.initialize(context, params);
        links = this.filterCollection(links);
        Collections.sort(links);
        String wikitext = null;
        if (this.m_show.equals("count")) {
            wikitext = "" + links.size();
            if (this.m_lastModified && links.size() != 0) {
                wikitext = String.valueOf(links.size()) + " (" + this.m_dateFormat.format(this.m_dateLastModified) + ")";
            }
        } else {
            wikitext = this.wikitizeCollection(links, this.m_separator, -1);
        }
        return this.makeHTML(context, wikitext);
    }
}

