/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.io.IOException;
import java.io.StringReader;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.PluginException;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.parser.Heading;
import org.apache.wiki.parser.HeadingListener;
import org.apache.wiki.parser.JSPWikiMarkupParser;
import org.apache.wiki.plugin.WikiPlugin;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.util.TextUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableOfContents
implements WikiPlugin,
HeadingListener {
    private static Logger log = LoggerFactory.getLogger(TableOfContents.class);
    public static final String PARAM_TITLE = "title";
    public static final String PARAM_NUMBERED = "numbered";
    public static final String PARAM_START = "start";
    public static final String PARAM_PREFIX = "prefix";
    private static final String VAR_ALREADY_PROCESSING = "__TableOfContents.processing";
    StringBuilder m_buf = new StringBuilder();
    private boolean m_usingNumberedList = false;
    private String m_prefix = "";
    private int m_starting = 0;
    private int m_level1Index = 0;
    private int m_level2Index = 0;
    private int m_level3Index = 0;
    private int m_lastLevel = 0;

    @Override
    public void headingAdded(WikiContext context, Heading hd) {
        log.debug("HD: " + hd.m_level + ", " + hd.m_titleText + ", " + hd.m_titleAnchor, new Object[0]);
        switch (hd.m_level) {
            case 1: {
                this.m_buf.append("<li class=\"toclevel-3\">");
                ++this.m_level3Index;
                break;
            }
            case 2: {
                this.m_buf.append("<li class=\"toclevel-2\">");
                ++this.m_level2Index;
                break;
            }
            case 3: {
                this.m_buf.append("<li class=\"toclevel-1\">");
                ++this.m_level1Index;
                break;
            }
            default: {
                throw new InternalWikiException("Unknown depth in toc! (Please submit a bug report.)");
            }
        }
        if (this.m_level1Index < this.m_starting) {
            ++this.m_level1Index;
        }
        if (this.m_lastLevel == 1 && hd.m_level != 1) {
            this.m_level3Index = 0;
        }
        if ((this.m_lastLevel == 1 || this.m_lastLevel == 2) && hd.m_level == 3) {
            this.m_level3Index = 0;
            this.m_level2Index = 0;
        }
        String titleSection = hd.m_titleSection.replace('%', '_');
        String pageName = context.getEngine().encodeName(context.getPage().getName()).replace('%', '_');
        String sectref = "#section-" + pageName + "-" + titleSection;
        this.m_buf.append("<a class=\"wikipage\" href=\"" + sectref + "\">");
        if (this.m_usingNumberedList) {
            switch (hd.m_level) {
                case 1: {
                    this.m_buf.append(String.valueOf(this.m_prefix) + this.m_level1Index + "." + this.m_level2Index + "." + this.m_level3Index + " ");
                    break;
                }
                case 2: {
                    this.m_buf.append(String.valueOf(this.m_prefix) + this.m_level1Index + "." + this.m_level2Index + " ");
                    break;
                }
                case 3: {
                    this.m_buf.append(String.valueOf(this.m_prefix) + this.m_level1Index + " ");
                    break;
                }
                default: {
                    throw new InternalWikiException("Unknown depth in toc! (Please submit a bug report.)");
                }
            }
        }
        this.m_buf.append(String.valueOf(TextUtil.replaceEntities(hd.m_titleText)) + "</a></li>\n");
        this.m_lastLevel = hd.m_level;
    }

    @Override
    public String execute(WikiContext context, Map<String, Object> params) throws PluginException {
        WikiEngine engine = context.getEngine();
        WikiPage page = context.getPage();
        ResourceBundle rb = context.getBundle("plugin.PluginResources");
        if (context.getVariable(VAR_ALREADY_PROCESSING) != null) {
            return "<a href=\"#section-TOC\" class=\"toc\">" + rb.getString("tableofcontents.title") + "</a>";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<div class=\"toc\">\n");
        sb.append("<div class=\"collapsebox\">\n");
        String title = (String)params.get(PARAM_TITLE);
        sb.append("<h4 id=\"section-TOC\">");
        if (title != null) {
            sb.append(TextUtil.replaceEntities(title));
        } else {
            sb.append(rb.getString("tableofcontents.title"));
        }
        sb.append("</h4>\n");
        this.m_usingNumberedList = false;
        if (params.containsKey(PARAM_NUMBERED)) {
            String numbered = (String)params.get(PARAM_NUMBERED);
            if (numbered.equalsIgnoreCase("true")) {
                this.m_usingNumberedList = true;
            } else if (numbered.equalsIgnoreCase("yes")) {
                this.m_usingNumberedList = true;
            }
        }
        if (this.m_usingNumberedList) {
            int start = 0;
            String startStr = (String)params.get(PARAM_START);
            if (startStr != null && startStr.matches("^\\d+$")) {
                start = Integer.parseInt(startStr);
            }
            if (start < 0) {
                start = 0;
            }
            this.m_starting = start;
            this.m_level1Index = start - 1;
            if (this.m_level1Index < 0) {
                this.m_level1Index = 0;
            }
            this.m_level2Index = 0;
            this.m_level3Index = 0;
            this.m_prefix = (String)params.get(PARAM_PREFIX);
            if (this.m_prefix == null) {
                this.m_prefix = "";
            }
            this.m_lastLevel = 3;
        }
        try {
            String wikiText = page.getContentAsString();
            boolean runFilters = "true".equals(engine.getVariableManager().getValue(context, "jspwiki.runFilters", "true"));
            try {
                if (runFilters) {
                    wikiText = engine.getFilterManager().doPreTranslateFiltering(context, wikiText);
                }
            }
            catch (Exception e) {
                log.error("Could not construct table of contents: Filter Error", e);
                throw new PluginException(rb.getString("tableofcontents.unable.construct"));
            }
            context.setVariable(VAR_ALREADY_PROCESSING, "x");
            JSPWikiMarkupParser parser = new JSPWikiMarkupParser(context, new StringReader(wikiText));
            parser.addHeadingListener(this);
            parser.parse();
            sb.append("<ul>\n" + this.m_buf.toString() + "</ul>\n");
        }
        catch (IOException e) {
            log.error("Could not construct table of contents", e);
            throw new PluginException(rb.getString("tableofcontents.unable.construct"));
        }
        catch (ProviderException e) {
            log.error("Could not construct table of contents", e);
            throw new PluginException(rb.getString("tableofcontents.unable.construct"));
        }
        sb.append("</div>\n</div>\n");
        return sb.toString();
    }
}

