/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiSession;
import org.apache.wiki.api.PluginException;
import org.apache.wiki.plugin.WikiPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionsPlugin
implements WikiPlugin {
    public static final String PARAM_PROP = "property";

    @Override
    public String execute(WikiContext context, Map<String, Object> params) throws PluginException {
        WikiEngine engine = context.getEngine();
        String prop = (String)params.get(PARAM_PROP);
        if ("users".equals(prop)) {
            Principal[] principals = WikiSession.userPrincipals(engine);
            StringBuilder s = new StringBuilder();
            int i = 0;
            while (i < principals.length) {
                s.append(String.valueOf(principals[i].getName()) + ", ");
                ++i;
            }
            return s.substring(0, s.length() - (s.length() > 2 ? 2 : 0));
        }
        if ("distinctUsers".equals(prop)) {
            Principal[] principals = WikiSession.userPrincipals(engine);
            HashMap<String, Integer> distinctPrincipals = new HashMap<String, Integer>();
            int i = 0;
            while (i < principals.length) {
                String principalName = principals[i].getName();
                if (distinctPrincipals.containsKey(principalName)) {
                    int numSessions = (Integer)distinctPrincipals.get(principalName);
                    distinctPrincipals.put(principalName, ++numSessions);
                } else {
                    distinctPrincipals.put(principalName, 1);
                }
                ++i;
            }
            StringBuilder s = new StringBuilder();
            for (Map.Entry entry : distinctPrincipals.entrySet()) {
                s.append(String.valueOf((String)entry.getKey()) + "(" + ((Integer)entry.getValue()).toString() + "), ");
            }
            return s.substring(0, s.length() - 2);
        }
        return String.valueOf(WikiSession.sessions(engine));
    }
}

