/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.b;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.th;
import org.apache.ecs.xhtml.tr;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.PluginException;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.plugin.WikiPlugin;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.search.SearchResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Search
implements WikiPlugin {
    static Logger log = LoggerFactory.getLogger(Search.class);
    public static final String PARAM_QUERY = "query";
    public static final String PARAM_SET = "set";
    public static final String DEFAULT_SETNAME = "_defaultSet";
    public static final String PARAM_MAX = "max";

    @Override
    public String execute(WikiContext context, Map<String, Object> params) throws PluginException {
        int maxItems = Integer.MAX_VALUE;
        Collection<SearchResult> results = null;
        String queryString = (String)params.get(PARAM_QUERY);
        String set = (String)params.get(PARAM_SET);
        String max = (String)params.get(PARAM_MAX);
        if (set == null) {
            set = DEFAULT_SETNAME;
        }
        if (max != null) {
            maxItems = Integer.parseInt(max);
        }
        if (queryString == null) {
            results = (Collection<SearchResult>)context.getVariable(set);
        } else {
            try {
                results = this.doBasicQuery(context, queryString);
                context.setVariable(set, results);
            }
            catch (Exception e) {
                return "<div class='error'>" + e.getMessage() + "</div>\n";
            }
        }
        String res = "";
        if (results != null) {
            res = this.renderResults(results, context, maxItems);
        }
        return res;
    }

    private Collection<SearchResult> doBasicQuery(WikiContext context, String query) throws ProviderException, IOException {
        log.debug("Searching for string " + query, new Object[0]);
        List<SearchResult> list = context.getEngine().findPages(query);
        return list;
    }

    private String renderResults(Collection<SearchResult> results, WikiContext context, int maxItems) {
        WikiEngine engine = context.getEngine();
        table t = new table();
        t.setBorder(0);
        t.setCellPadding(4);
        tr row = new tr();
        t.addElement((Element)row);
        row.addElement((Element)new th().setWidth("30%").setAlign("left").addElement("Page"));
        row.addElement((Element)new th().setAlign("left").addElement("Score"));
        int idx = 0;
        Iterator<SearchResult> i = results.iterator();
        while (i.hasNext() && idx++ <= maxItems) {
            SearchResult sr = i.next();
            row = new tr();
            td name = new td().setWidth("30%");
            name.addElement("<a href=\"" + context.getURL(WikiContext.VIEW, sr.getPage().getName()) + "\">" + engine.beautifyTitle(sr.getPage().getPath()) + "</a>");
            row.addElement((Element)name);
            row.addElement((Element)new td().addElement("" + sr.getScore()));
            t.addElement((Element)row);
        }
        if (results.isEmpty()) {
            row = new tr();
            row.addElement((Element)new td().setColSpan(2).addElement((Element)new b().addElement("No results")));
            t.addElement((Element)row);
        }
        return t.toString();
    }
}

