/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.PluginException;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.content.PageNotFoundException;
import org.apache.wiki.content.ReferenceManager;
import org.apache.wiki.content.WikiPath;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.plugin.AbstractFilteredPlugin;
import org.apache.wiki.plugin.WikiPlugin;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.util.TextUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferredPagesPlugin
extends AbstractFilteredPlugin
implements WikiPlugin {
    private static Logger log = LoggerFactory.getLogger(ReferredPagesPlugin.class);
    private WikiEngine m_engine;
    private int m_depth;
    private HashSet<WikiPath> m_exists = new HashSet();
    private StringBuilder m_result = new StringBuilder(1024);
    private boolean m_formatCompact = true;
    private boolean m_formatSort = false;
    public static final String PARAM_ROOT = "page";
    public static final String PARAM_DEPTH = "depth";
    public static final String PARAM_FORMAT = "format";
    public static final int MIN_DEPTH = 1;
    public static final int MAX_DEPTH = 8;

    @Override
    public String execute(WikiContext context, Map<String, Object> params) throws PluginException {
        String format;
        this.m_engine = context.getEngine();
        super.initialize(context, params);
        WikiPage page = context.getPage();
        if (page == null) {
            return "";
        }
        String rootname = (String)params.get(PARAM_ROOT);
        if (rootname == null) {
            rootname = page.getName();
        }
        if ((format = (String)params.get(PARAM_FORMAT)) == null) {
            format = "";
        }
        if (format.indexOf("full") >= 0) {
            this.m_formatCompact = false;
        }
        if (format.indexOf("sort") >= 0) {
            this.m_formatSort = true;
        }
        this.m_depth = TextUtil.parseIntParameter((String)params.get(PARAM_DEPTH), 1);
        if (this.m_depth > 8) {
            this.m_depth = 8;
        }
        String includePattern = this.filterString(this.m_include);
        String excludePattern = this.filterString(this.m_exclude);
        String href = context.getViewURL(rootname);
        String title = "ReferredPagesPlugin: depth[" + this.m_depth + "] include[" + includePattern + "] exclude[" + excludePattern + "] format[" + (this.m_formatCompact ? "compact" : "full") + (this.m_formatSort ? " sort" : "") + "]";
        this.m_result.append("<div class=\"ReferredPagesPlugin\">\n");
        this.m_result.append("<a class=\"wikipage\" href=\"" + href + "\" title=\"" + title + "\">" + rootname + "</a>\n");
        this.m_exists.add(WikiPath.valueOf(rootname));
        try {
            this.getReferredPages(context, WikiPath.valueOf(rootname), 0);
        }
        catch (Exception e) {
            throw new PluginException("Failed to get referred pages " + e.getMessage());
        }
        this.m_result.append("</div>\n");
        return this.m_result.toString();
    }

    private String filterString(Pattern[] patterns) {
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < patterns.length) {
            s.append(patterns[i].pattern());
            if (i < patterns.length - 1) {
                s.append(',');
            }
            ++i;
        }
        return s.toString();
    }

    private void getReferredPages(WikiContext context, WikiPath path, int depth) throws ProviderException, PageNotFoundException {
        if (depth >= this.m_depth) {
            return;
        }
        if (path == null) {
            return;
        }
        if (!this.m_engine.pageExists(path.toString())) {
            return;
        }
        ReferenceManager mgr = this.m_engine.getReferenceManager();
        List<WikiPath> pages = mgr.getRefersTo(path);
        if (pages != null && pages.size() > 0) {
            pages = super.filterCollection(pages);
        }
        this.handleLinks(context, pages, ++depth, path);
    }

    private void handleLinks(WikiContext context, List<WikiPath> links, int depth, WikiPath path) throws ProviderException, PageNotFoundException {
        boolean isUL = false;
        links.add(path);
        if (this.m_formatSort) {
            Collections.sort(links);
        }
        for (WikiPath link : links) {
            if (!this.m_engine.pageExists(link.toString())) continue;
            if (this.m_exists.contains(link)) {
                if (this.m_formatCompact) continue;
                if (!isUL) {
                    isUL = true;
                    this.m_result.append("<ul>\n");
                }
                this.m_result.append("<li> " + link.getName() + " </li>\n");
                this.getReferredPages(context, link, depth);
                continue;
            }
            if (!isUL) {
                isUL = true;
                this.m_result.append("<ul>\n");
            }
            String href = context.getURL(WikiContext.VIEW, link.getName());
            this.m_result.append("<li><a class=\"wikipage\" href=\"" + href + "\">" + link.getName() + "</a></li>\n");
            this.m_exists.add(link);
            this.getReferredPages(context, link, depth);
        }
        if (isUL) {
            this.m_result.append("</ul>\n");
        }
    }
}

