/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.b;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.PluginException;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.plugin.AbstractFilteredPlugin;
import org.apache.wiki.plugin.WikiPlugin;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.ui.TemplateManager;
import org.apache.wiki.util.TextUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecentChangesPlugin
extends AbstractFilteredPlugin
implements WikiPlugin {
    public static final String PARAM_FORMAT = "format";
    public static final String PARAM_TIME_FORMAT = "timeFormat";
    public static final String PARAM_DATE_FORMAT = "dateFormat";
    private static final int DEFAULT_DAYS = 36500;
    public static final String DEFAULT_TIME_FORMAT = "HH:mm:ss";
    public static final String DEFAULT_DATE_FORMAT = "dd.MM.yyyy";
    private static Logger log = LoggerFactory.getLogger(RecentChangesPlugin.class);

    private boolean isSameDay(Date a, Date b) {
        Calendar aa = Calendar.getInstance();
        aa.setTime(a);
        Calendar bb = Calendar.getInstance();
        bb.setTime(b);
        return aa.get(1) == bb.get(1) && aa.get(6) == bb.get(6);
    }

    @Override
    public String execute(WikiContext context, Map<String, Object> params) throws PluginException {
        int since = TextUtil.parseIntParameter((String)params.get("since"), 36500);
        int spacing = 4;
        boolean showAuthor = true;
        boolean showChangenote = true;
        int tablewidth = 4;
        WikiEngine engine = context.getEngine();
        if ("compact".equals(params.get(PARAM_FORMAT))) {
            spacing = 0;
            showAuthor = false;
            showChangenote = false;
            tablewidth = 2;
        }
        GregorianCalendar sincedate = new GregorianCalendar();
        ((Calendar)sincedate).add(5, -since);
        log.debug("Calculating recent changes from " + sincedate.getTime(), new Object[0]);
        List<WikiPage> changes = engine.getRecentChanges(null);
        super.initialize(context, params);
        changes = super.filterCollection(changes);
        if (changes != null) {
            Date olddate = new Date(0L);
            DateFormat fmt = this.getDateFormat(context, params);
            DateFormat tfmt = this.getTimeFormat(context, params);
            table rt = new table();
            rt.setCellPadding(spacing).setClass("recentchanges");
            for (WikiPage pageref : changes) {
                try {
                    Date lastmod = pageref.getLastModified();
                    if (lastmod == null || !lastmod.after(sincedate.getTime())) continue;
                    if (!this.isSameDay(lastmod, olddate)) {
                        tr row = new tr();
                        td col = new td();
                        col.setColSpan(tablewidth).setClass("date");
                        col.addElement((Element)new b().addElement(fmt.format(lastmod)));
                        rt.addElement((Element)row);
                        row.addElement((Element)col);
                        olddate = lastmod;
                    }
                    String link = context.getURL(pageref.isAttachment() ? WikiContext.ATTACH : WikiContext.VIEW, pageref.getName());
                    a linkel = new a(link, engine.beautifyTitle(pageref.getName()));
                    tr row = new tr();
                    td col = new td().setWidth("30%").addElement((Element)linkel);
                    if (pageref.isAttachment()) {
                        linkel = new a().setHref(context.getURL(WikiContext.INFO, pageref.getName()));
                        linkel.setClass("infolink");
                        String src = TemplateManager.getResourceResolver(this.m_engine.getServletContext()).get("attachment_small.png");
                        linkel.addElement((Element)new img().setSrc(src));
                        col.addElement((Element)linkel);
                    }
                    row.addElement((Element)col);
                    rt.addElement((Element)row);
                    if (pageref.isAttachment()) {
                        row.addElement(new td(tfmt.format(lastmod)).setClass("lastchange"));
                    } else {
                        td infocol = (td)new td().setClass("lastchange");
                        infocol.addElement((Element)new a(context.getURL(WikiContext.DIFF, pageref.getName(), "r1=-1"), tfmt.format(lastmod)));
                        row.addElement((Element)infocol);
                    }
                    if (showAuthor) {
                        String author = pageref.getAuthor();
                        td authorinfo = new td();
                        authorinfo.setClass("author");
                        if (author != null) {
                            if (engine.pageExists(author)) {
                                authorinfo.addElement((Element)new a(context.getURL(WikiContext.VIEW, author), author));
                            } else {
                                authorinfo.addElement(author);
                            }
                        } else {
                            authorinfo.addElement(context.getBundle("CoreResources").getString("common.unknownauthor"));
                        }
                        row.addElement((Element)authorinfo);
                    }
                    if (!showChangenote) continue;
                    String changenote = (String)((Object)pageref.getAttribute("changenote"));
                    row.addElement(new td(changenote != null ? TextUtil.replaceEntities(changenote) : "").setClass("changenote"));
                }
                catch (ProviderException e) {
                    throw new PluginException("Could not determine whether WikiPage " + pageref.getName() + " is an attachment.", e);
                }
            }
            rt.setPrettyPrint(true);
            return rt.toString();
        }
        return "";
    }

    private DateFormat getTimeFormat(WikiContext context, Map<String, Object> params) {
        String formatString = this.get(params, DEFAULT_TIME_FORMAT, PARAM_TIME_FORMAT);
        if ("".equals(formatString.trim())) {
            Preferences prefs = Preferences.getPreferences(context.getHttpRequest());
            return prefs.getDateFormat(Preferences.TimeFormat.TIME);
        }
        return new SimpleDateFormat(formatString);
    }

    private DateFormat getDateFormat(WikiContext context, Map<String, Object> params) {
        String formatString = this.get(params, DEFAULT_DATE_FORMAT, PARAM_DATE_FORMAT);
        if ("".equals(formatString.trim())) {
            Preferences prefs = Preferences.getPreferences(context.getHttpRequest());
            return prefs.getDateFormat(Preferences.TimeFormat.DATE);
        }
        return new SimpleDateFormat(formatString);
    }

    private String get(Map<String, Object> params, String defaultValue, String paramName) {
        String value = (String)params.get(paramName);
        return value == null ? defaultValue : value;
    }
}

