/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sourceforge.stripes.util.ResolverUtil;
import org.apache.commons.lang.ClassUtils;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.b;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.li;
import org.apache.ecs.xhtml.pre;
import org.apache.ecs.xhtml.ul;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.ModuleData;
import org.apache.wiki.api.PluginException;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.modules.ModuleManager;
import org.apache.wiki.modules.WikiModuleInfo;
import org.apache.wiki.parser.PluginContent;
import org.apache.wiki.plugin.InitializablePlugin;
import org.apache.wiki.plugin.ParserStagePlugin;
import org.apache.wiki.plugin.WikiPlugin;
import org.apache.wiki.util.ClassUtil;
import org.apache.wiki.util.FileUtil;
import org.apache.wiki.util.TextUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginManager
extends ModuleManager {
    private static final String PLUGIN_INSERT_PATTERN = "\\{?(INSERT)?\\s*([\\w\\._]+)[ \\t]*(WHERE)?[ \\t]*";
    private static Logger log = LoggerFactory.getLogger(PluginManager.class);
    public static final String DEFAULT_PACKAGE = "org.apache.wiki.plugin";
    private static final String DEFAULT_FORMS_PACKAGE = "org.apache.wiki.forms";
    public static final String PARAM_BODY = "_body";
    public static final String PARAM_CMDLINE = "_cmdline";
    public static final String PARAM_BOUNDS = "_bounds";
    public static final String PARAM_DEBUG = "debug";
    private List<String> m_searchPath;
    private Pattern m_pluginPattern;
    private boolean m_pluginsEnabled = true;
    private Map<String, WikiPluginInfo> m_pluginClassMap = new HashMap<String, WikiPluginInfo>();

    public PluginManager(WikiEngine engine, Properties props) {
        super(engine);
        this.m_searchPath = this.buildPluginSearchPath(props);
        this.registerAllPlugins();
        this.m_searchPath.add(DEFAULT_PACKAGE);
        this.m_searchPath.add(DEFAULT_FORMS_PACKAGE);
        try {
            this.m_pluginPattern = Pattern.compile(PLUGIN_INSERT_PATTERN);
        }
        catch (PatternSyntaxException e) {
            log.error("Internal error: someone messed with pluginmanager patterns.", e);
            throw new InternalWikiException("PluginManager patterns are broken");
        }
    }

    public void enablePlugins(boolean enabled) {
        this.m_pluginsEnabled = enabled;
    }

    public boolean pluginsEnabled() {
        return this.m_pluginsEnabled;
    }

    public static boolean isPluginLink(String link) {
        return link.startsWith("{INSERT") || link.startsWith("{") && !link.startsWith("{$");
    }

    private Class<? extends WikiPlugin> findPluginClass(String classname) throws ClassNotFoundException {
        return ClassUtil.findClass(this.m_searchPath, classname);
    }

    private String stackTrace(Map<String, Object> params, Throwable t) {
        div d = new div();
        d.setClass(PARAM_DEBUG);
        d.addElement("Plugin execution failed, stack trace follows:");
        StringWriter out = new StringWriter();
        t.printStackTrace(new PrintWriter(out));
        d.addElement((Element)new pre(out.toString()));
        d.addElement((Element)new b("Parameters to the plugin"));
        ul list = new ul();
        for (Map.Entry<String, Object> e : params.entrySet()) {
            String key = e.getKey();
            list.addElement((Element)new li(String.valueOf(key) + "'='" + e.getValue()));
        }
        d.addElement((Element)list);
        return d.toString();
    }

    public String execute(WikiContext context, String classname, Map<String, Object> params) throws PluginException {
        if (!this.m_pluginsEnabled) {
            return "";
        }
        ResourceBundle rb = context.getBundle("plugin.PluginResources");
        Object[] args = new Object[]{classname};
        try {
            WikiPlugin plugin;
            boolean debug = TextUtil.isPositive((String)params.get(PARAM_DEBUG));
            WikiPluginInfo pluginInfo = this.m_pluginClassMap.get(classname);
            if (pluginInfo == null) {
                pluginInfo = WikiPluginInfo.newInstance(this.findPluginClass(classname));
                this.registerPlugin(pluginInfo);
            }
            if (!this.checkCompatibility(pluginInfo)) {
                String msg = "Plugin '" + pluginInfo.getName() + "' not compatible with this version of JSPWiki";
                log.info(msg, new Object[0]);
                return msg;
            }
            try {
                plugin = pluginInfo.newPluginInstance();
            }
            catch (InstantiationException e) {
                throw new PluginException(MessageFormat.format(rb.getString("plugin.error.cannotinstantiate"), args), e);
            }
            catch (IllegalAccessException e) {
                throw new PluginException(MessageFormat.format(rb.getString("plugin.error.notallowed"), args), e);
            }
            catch (Exception e) {
                throw new PluginException(MessageFormat.format(rb.getString("plugin.error.instantationfailed"), args), e);
            }
            try {
                return plugin.execute(context, params);
            }
            catch (PluginException e) {
                if (debug) {
                    return this.stackTrace(params, e);
                }
                throw (PluginException)e.fillInStackTrace();
            }
            catch (Throwable t) {
                log.info("Plugin failed while executing:", t, new Object[0]);
                if (debug) {
                    return this.stackTrace(params, t);
                }
                throw new PluginException(rb.getString("plugin.error.failed"), t);
            }
        }
        catch (ClassNotFoundException e) {
            throw new PluginException(MessageFormat.format(rb.getString("plugin.error.couldnotfind"), args), e);
        }
        catch (ClassCastException e) {
            throw new PluginException(MessageFormat.format(rb.getString("plugin.error.notawikiplugin"), args), e);
        }
    }

    public Map<String, Object> parseArgs(String argstring) throws IOException {
        HashMap<String, Object> arglist = new HashMap<String, Object>();
        if (argstring == null) {
            return arglist;
        }
        arglist.put(PARAM_CMDLINE, argstring);
        StringReader in = new StringReader(argstring);
        StreamTokenizer tok = new StreamTokenizer(in);
        String param = null;
        String value = null;
        tok.eolIsSignificant(true);
        boolean potentialEmptyLine = false;
        boolean quit = false;
        while (!quit) {
            String s;
            int type = tok.nextToken();
            switch (type) {
                case -1: {
                    quit = true;
                    s = null;
                    break;
                }
                case -3: {
                    s = tok.sval;
                    potentialEmptyLine = false;
                    break;
                }
                case 10: {
                    quit = potentialEmptyLine;
                    potentialEmptyLine = true;
                    s = null;
                    break;
                }
                case -2: {
                    s = Integer.toString((int)tok.nval);
                    potentialEmptyLine = false;
                    break;
                }
                case 39: {
                    s = tok.sval;
                    break;
                }
                default: {
                    s = null;
                }
            }
            if (s == null) continue;
            if (param == null) {
                param = s;
                continue;
            }
            value = s;
            arglist.put(param, value);
            param = null;
        }
        if (potentialEmptyLine) {
            StringWriter out = new StringWriter();
            FileUtil.copyContents(in, out);
            String bodyContent = out.toString();
            if (bodyContent != null) {
                arglist.put(PARAM_BODY, bodyContent);
            }
        }
        return arglist;
    }

    public String execute(WikiContext context, String commandline) throws PluginException {
        if (!this.m_pluginsEnabled) {
            return "";
        }
        Object[] obArgs = new Object[]{commandline};
        Matcher matcher = this.m_pluginPattern.matcher(commandline);
        try {
            if (matcher.find()) {
                MatchResult res = matcher.toMatchResult();
                String plugin = res.group(2);
                String args = commandline.substring(res.end(), commandline.length() - (commandline.charAt(commandline.length() - 1) == '}' ? 1 : 0));
                Map<String, Object> arglist = this.parseArgs(args);
                return this.execute(context, plugin, arglist);
            }
        }
        catch (NoSuchElementException e) {
            String msg = "Missing parameter in plugin definition: " + commandline;
            log.warn(msg, e, new Object[0]);
            ResourceBundle rb = context.getBundle("plugin.PluginResources");
            throw new PluginException(MessageFormat.format(rb.getString("plugin.error.missingparameter"), obArgs));
        }
        catch (IOException e) {
            String msg = "Zyrf.  Problems with parsing arguments: " + commandline;
            log.warn(msg, e, new Object[0]);
            ResourceBundle rb = context.getBundle("plugin.PluginResources");
            throw new PluginException(MessageFormat.format(rb.getString("plugin.error.parsingarguments"), obArgs));
        }
        return commandline;
    }

    public PluginContent parsePluginLine(WikiContext context, String commandline, int pos) throws PluginException {
        Matcher matcher = this.m_pluginPattern.matcher(commandline);
        try {
            if (matcher.find()) {
                MatchResult res = matcher.toMatchResult();
                String plugin = res.group(2);
                String args = commandline.substring(res.end(0), commandline.length() - (commandline.charAt(commandline.length() - 1) == '}' ? 1 : 0));
                Map<String, Object> arglist = this.parseArgs(args);
                if (pos != -1) {
                    int end = pos + commandline.length() + 2;
                    int[] bounds = new int[]{pos, end};
                    arglist.put(PARAM_BOUNDS, bounds);
                }
                PluginContent result = new PluginContent(plugin, arglist);
                return result;
            }
        }
        catch (ClassCastException e) {
            log.error("Invalid type offered in parsing plugin arguments.", e);
            throw new InternalWikiException("Oops, someone offered !String!");
        }
        catch (NoSuchElementException e) {
            String msg = "Missing parameter in plugin definition: " + commandline;
            log.warn(msg, e, new Object[0]);
            ResourceBundle rb = context.getBundle("plugin.PluginResources");
            throw new PluginException(rb.getString("plugin.error.missingparameter"));
        }
        catch (IOException e) {
            String msg = "Zyrf.  Problems with parsing arguments: " + commandline;
            log.warn(msg, e, new Object[0]);
            ResourceBundle rb = context.getBundle("plugin.PluginResources");
            throw new PluginException(rb.getString("plugin.error.parsingarguments"));
        }
        return null;
    }

    private void registerPlugin(WikiPluginInfo pluginClass) {
        String[] aliases;
        String name = pluginClass.getName();
        if (name != null) {
            log.debug("Registering plugin [name]: %s", name);
            this.m_pluginClassMap.put(name, pluginClass);
        }
        if ((aliases = pluginClass.getAliases()) != null) {
            String[] stringArray = aliases;
            int n = aliases.length;
            int n2 = 0;
            while (n2 < n) {
                String a2 = stringArray[n2];
                log.debug("Registering plugin [shortName]: %s", a2);
                this.m_pluginClassMap.put(a2, pluginClass);
                ++n2;
            }
        }
        if ((name = pluginClass.getClassName()) != null) {
            log.debug("Registering plugin [className]: %s", name);
            this.m_pluginClassMap.put(name, pluginClass);
        }
        pluginClass.initializePlugin(this.m_engine);
    }

    private void registerAllPlugins() {
        log.info("Registering plugins", new Object[0]);
        ResolverUtil resolver = new ResolverUtil();
        String[] paths = this.m_searchPath.toArray(new String[0]);
        resolver.findImplementations(WikiPlugin.class, paths);
        Set resultSet = resolver.getClasses();
        log.debug("Found %d plugins", resultSet.size());
        for (Class clazz : resultSet) {
            if (!clazz.isInterface() & !Modifier.isAbstract(clazz.getModifiers())) {
                WikiPluginInfo pluginInfo = WikiPluginInfo.newInstance(clazz);
                if (pluginInfo == null) continue;
                this.registerPlugin(pluginInfo);
                continue;
            }
            log.debug("Plugin class " + clazz.getName() + " not registered, it is either an interface or it is abstract", new Object[0]);
        }
    }

    public Collection<WikiPluginInfo> modules() {
        TreeSet<WikiPluginInfo> ls = new TreeSet<WikiPluginInfo>();
        for (WikiPluginInfo wmi : this.m_pluginClassMap.values()) {
            if (ls.contains(wmi)) continue;
            ls.add(wmi);
        }
        return ls;
    }

    public void executeParse(PluginContent content, WikiContext context) throws PluginException {
        if (!this.m_pluginsEnabled) {
            return;
        }
        ResourceBundle rb = context.getBundle("plugin.PluginResources");
        Object[] args = new Object[]{content.getPluginName()};
        Map<String, Object> params = content.getParameters();
        try {
            WikiPluginInfo pluginInfo = this.m_pluginClassMap.get(content.getPluginName());
            if (pluginInfo == null) {
                pluginInfo = WikiPluginInfo.newInstance(this.findPluginClass(content.getPluginName()));
                this.registerPlugin(pluginInfo);
            }
            if (!this.checkCompatibility(pluginInfo)) {
                String msg = "Plugin '" + pluginInfo.getName() + "' not compatible with this version of JSPWiki";
                log.info(msg, new Object[0]);
                return;
            }
            WikiPlugin plugin = pluginInfo.newPluginInstance();
            if (plugin instanceof ParserStagePlugin) {
                ((ParserStagePlugin)((Object)plugin)).executeParser(content, context, params);
            }
        }
        catch (InstantiationException e) {
            throw new PluginException(MessageFormat.format(rb.getString("plugin.error.cannotinstantiate"), args), e);
        }
        catch (IllegalAccessException e) {
            throw new PluginException(MessageFormat.format(rb.getString("plugin.error.notallowed"), args), e);
        }
        catch (ClassNotFoundException e) {
            throw new PluginException(MessageFormat.format(rb.getString("plugin.error.couldnotfind"), args));
        }
        catch (ClassCastException e) {
            throw new PluginException(MessageFormat.format(rb.getString("plugin.error.notawikiplugin"), args), e);
        }
        catch (Exception e) {
            throw new PluginException(MessageFormat.format(rb.getString("plugin.error.instantationfailed"), args), e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class WikiPluginInfo
    extends WikiModuleInfo {
        String[] m_aliases;
        Class<? extends WikiPlugin> m_clazz;
        boolean m_initialized = false;

        protected static WikiPluginInfo newInstance(Class<? extends WikiPlugin> clazz) {
            WikiPluginInfo info = new WikiPluginInfo(clazz);
            return info;
        }

        private WikiPluginInfo(Class<? extends WikiPlugin> clazz) {
            super(clazz.getName());
            this.setClassName(clazz.getName());
            this.initializeFromClass(clazz);
            this.m_clazz = clazz;
            ModuleData md = clazz.getAnnotation(ModuleData.class);
            if (md != null) {
                this.m_aliases = md.aliases();
            }
        }

        private void setClassName(String fullClassName) {
            this.m_name = ClassUtils.getShortClassName((String)fullClassName);
        }

        public String getClassName() {
            return this.m_clazz.getCanonicalName();
        }

        public String[] getAliases() {
            return this.m_aliases;
        }

        public WikiPlugin newPluginInstance() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
            return this.m_clazz.newInstance();
        }

        public String getIncludeText(String type) {
            try {
                if (type.equals("script")) {
                    return this.getScriptText();
                }
                if (type.equals("stylesheet")) {
                    return this.getStylesheetText();
                }
            }
            catch (Exception ex) {
                return ex.getMessage();
            }
            return null;
        }

        private String getScriptText() throws IOException {
            if (this.m_scriptText != null) {
                return this.m_scriptText;
            }
            if (this.m_scriptLocation == null) {
                return "";
            }
            try {
                this.m_scriptText = this.getTextResource(this.m_scriptLocation[0]);
            }
            catch (IOException ex) {
                this.m_scriptText = "";
                throw ex;
            }
            return this.m_scriptText;
        }

        private String getStylesheetText() throws IOException {
            if (this.m_stylesheetText != null) {
                return this.m_stylesheetText;
            }
            if (this.m_stylesheetLocation == null) {
                return "";
            }
            try {
                this.m_stylesheetText = this.getTextResource(this.m_stylesheetLocation[0]);
            }
            catch (IOException ex) {
                this.m_stylesheetText = "";
                throw ex;
            }
            return this.m_stylesheetText;
        }

        protected void initializePlugin(WikiEngine engine) {
            if (!this.m_initialized) {
                this.m_initialized = true;
                try {
                    WikiPlugin p = this.newPluginInstance();
                    if (p instanceof InitializablePlugin) {
                        ((InitializablePlugin)((Object)p)).initialize(engine);
                    }
                }
                catch (Exception e) {
                    log.info("Cannot initialize plugin '%s'", e, this.m_clazz.getCanonicalName());
                }
            }
        }

        public String toString() {
            return "Plugin :[name=" + this.m_name + "][className=" + this.m_clazz.getCanonicalName() + "]";
        }
    }
}

