/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.util.Collection;
import java.util.Map;
import org.apache.wiki.WikiContext;
import org.apache.wiki.api.ModuleData;
import org.apache.wiki.api.PluginException;
import org.apache.wiki.modules.WikiModuleInfo;
import org.apache.wiki.plugin.AbstractFilteredPlugin;
import org.apache.wiki.plugin.PluginManager;
import org.apache.wiki.plugin.WikiPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ModuleData(minVersion="3.0", maxVersion="1000000", minAPIVersion="2.8")
public class PluginIndexPlugin
extends AbstractFilteredPlugin
implements WikiPlugin {
    public static final String PARAM_DETAILS = "details";
    private static final String BLANK = "&nbsp;";

    @Override
    public String execute(WikiContext context, Map<String, Object> params) throws PluginException {
        super.initialize(context, params);
        String details = (String)params.get(PARAM_DETAILS);
        String summaryHeader = "\n||name";
        String detailHeader = "\n||Name||Class Name||alias's||author||minVersion||maxVersion||adminBean Class";
        Collection<PluginManager.WikiPluginInfo> plugins = context.getEngine().getPluginManager().modules();
        StringBuilder wikitext = new StringBuilder();
        if ("true".equals(details)) {
            wikitext.append(detailHeader);
            for (PluginManager.WikiPluginInfo wikiPluginInfo : plugins) {
                String adminBeanClazz;
                String maxVersion;
                String minVersion;
                String name = wikiPluginInfo.getName();
                String clazz = wikiPluginInfo.getClassName();
                String[] aliass = wikiPluginInfo.getAliases();
                String author = wikiPluginInfo.getAuthor();
                if (author == null) {
                    author = BLANK;
                }
                if ((minVersion = wikiPluginInfo.getMinVersion()) == null) {
                    minVersion = BLANK;
                }
                if ((maxVersion = wikiPluginInfo.getMaxVersion()) == null) {
                    maxVersion = BLANK;
                }
                if ((adminBeanClazz = wikiPluginInfo.getAdminBeanClass()) == null) {
                    adminBeanClazz = BLANK;
                }
                StringBuilder aliassString = new StringBuilder(BLANK);
                if (aliass != null) {
                    int i = 0;
                    while (i < aliass.length) {
                        aliassString.append(" " + aliass[i]);
                        ++i;
                    }
                }
                wikitext.append("\n|" + name + "|" + clazz + "|" + aliassString + "|" + author + "|" + minVersion + "|" + maxVersion + "|" + adminBeanClazz);
            }
        } else {
            wikitext.append(summaryHeader);
            for (WikiModuleInfo wikiModuleInfo : plugins) {
                String name = wikiModuleInfo.getName();
                wikitext.append("\n|" + name);
            }
        }
        return this.makeHTML(context, wikitext.toString());
    }
}

