/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.PluginException;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.content.ReferenceManager;
import org.apache.wiki.event.WikiEngineEvent;
import org.apache.wiki.event.WikiEvent;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.plugin.AbstractFilteredPlugin;
import org.apache.wiki.plugin.InitializablePlugin;
import org.apache.wiki.plugin.WikiPlugin;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.util.RegExpUtil;
import org.apache.wiki.util.TextUtil;
import org.apache.wiki.util.WikiBackgroundThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageViewPlugin
extends AbstractFilteredPlugin
implements WikiPlugin,
InitializablePlugin {
    private static final Logger log = LoggerFactory.getLogger(PageViewPlugin.class);
    private static PageViewManager c_singleton;
    private static final String PARAM_COUNT = "count";
    private static final String PARAM_MAX_ENTRIES = "entries";
    private static final String PARAM_MAX_COUNT = "max";
    private static final String PARAM_MIN_COUNT = "min";
    private static final String PARAM_REFER = "refer";
    private static final String PARAM_SORT = "sort";
    private static final String STR_NONE = "none";
    private static final String STR_LIST = "list";
    private static final String STR_YES = "yes";
    private static final String STR_EMPTY = "";
    private static final String STR_SEPARATOR = "----";
    private static final String STR_COMMA = ",";
    private static final String STR_GLOBSTAR = "*";
    protected static final String COUNTER_PAGE = "PageCount.txt";
    private static final int STORAGE_INTERVAL = 60;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(WikiEngine engine) {
        log.info("initializing PageViewPlugin", new Object[0]);
        PageViewPlugin pageViewPlugin = this;
        synchronized (pageViewPlugin) {
            if (c_singleton == null) {
                c_singleton = new PageViewManager();
                c_singleton.initialize(engine);
            }
        }
    }

    private void cleanup() {
        log.info("cleaning up PageView Manager", new Object[0]);
        c_singleton = null;
    }

    @Override
    public String execute(WikiContext context, Map<String, Object> params) throws PluginException {
        ResourceBundle rb = context.getBundle("plugin.PluginResources");
        PageViewManager manager = c_singleton;
        String result = STR_EMPTY;
        if (manager != null) {
            try {
                result = manager.execute(context, params);
            }
            catch (ProviderException e) {
                log.error("exception while executing PageViewPlugin, stacktrace follows", e);
                result = rb.getString("plugin.pageview.error");
            }
        }
        return result;
    }

    private static final class Counter {
        private int m_count;

        public Counter() {
        }

        public Counter(String value) {
            this.setValue(value);
        }

        public void increment() {
            ++this.m_count;
        }

        public int getValue() {
            return this.m_count;
        }

        public void setValue(String value) {
            try {
                this.m_count = Integer.parseInt(value);
            }
            catch (Exception ignore) {
                this.m_count = 0;
            }
        }

        public String toString() {
            return String.valueOf(this.m_count);
        }
    }

    static final class CounterSaveThread
    extends WikiBackgroundThread {
        private final PageViewManager m_manager;

        public CounterSaveThread(WikiEngine engine, int interval, PageViewManager pageViewManager) {
            super(engine, interval);
            if (pageViewManager == null) {
                throw new IllegalArgumentException("Manager cannot be null");
            }
            this.m_manager = pageViewManager;
            this.setName("Counter Saver");
        }

        public void backgroundTask() {
            this.m_manager.storeCounters();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class PageViewManager
    implements WikiEventListener {
        private boolean m_initialized;
        private Map<String, Counter> m_counters;
        private Properties m_storage;
        private boolean m_dirty;
        private WikiBackgroundThread m_pageCountSaveThread;
        private String m_workDir;
        private final Comparator<Object> m_compareCountDescending = new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                int v2;
                int v1 = PageViewManager.this.getCount(o1);
                return v1 == (v2 = PageViewManager.this.getCount(o2)) ? ((String)o1).compareTo((String)o2) : (v1 < v2 ? 1 : -1);
            }
        };

        public synchronized void initialize(WikiEngine engine) {
            log.info("initializing PageView Manager", new Object[0]);
            this.m_workDir = engine.getWorkDir();
            engine.addWikiEventListener(this);
            if (this.m_counters == null) {
                this.m_storage = new Properties();
                this.m_counters = new TreeMap<String, Counter>();
                this.loadCounters();
            }
            if (this.m_pageCountSaveThread == null) {
                this.m_pageCountSaveThread = new CounterSaveThread(engine, 300, this);
                this.m_pageCountSaveThread.start();
            }
            this.m_initialized = true;
        }

        private synchronized void handleShutdown() {
            log.info("handleShutdown: The counter store thread was shut down.", new Object[0]);
            PageViewPlugin.this.cleanup();
            if (this.m_counters != null) {
                this.m_dirty = true;
                this.storeCounters();
                this.m_counters.clear();
                this.m_counters = null;
                this.m_storage.clear();
                this.m_storage = null;
            }
            this.m_initialized = false;
            this.m_pageCountSaveThread = null;
        }

        @Override
        public void actionPerformed(WikiEvent event) {
            if (event instanceof WikiEngineEvent && event.getType() == 1) {
                log.info("Detected wiki engine shutdown", new Object[0]);
                this.handleShutdown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String execute(WikiContext context, Map<String, Object> params) throws PluginException, ProviderException {
            WikiEngine engine = context.getEngine();
            WikiPage page = context.getPage();
            String result = PageViewPlugin.STR_EMPTY;
            if (page != null) {
                String pagename = page.getName();
                String count = (String)params.get(PageViewPlugin.PARAM_COUNT);
                String show = (String)params.get("show");
                int entries = TextUtil.parseIntParameter((String)params.get(PageViewPlugin.PARAM_MAX_ENTRIES), Integer.MAX_VALUE);
                int max = TextUtil.parseIntParameter((String)params.get(PageViewPlugin.PARAM_MAX_COUNT), Integer.MAX_VALUE);
                int min = TextUtil.parseIntParameter((String)params.get(PageViewPlugin.PARAM_MIN_COUNT), Integer.MIN_VALUE);
                String sort = (String)params.get(PageViewPlugin.PARAM_SORT);
                String body = (String)params.get("_body");
                Pattern[] exclude = this.compileGlobs("exclude", (String)params.get("exclude"));
                Pattern[] include = this.compileGlobs("include", (String)params.get("include"));
                Pattern[] refer = this.compileGlobs(PageViewPlugin.PARAM_REFER, (String)params.get(PageViewPlugin.PARAM_REFER));
                boolean increment = false;
                if (PageViewPlugin.STR_YES.equals(count)) {
                    increment = true;
                } else {
                    count = null;
                }
                if ((show == null || PageViewPlugin.STR_NONE.equals(show)) && count == null) {
                    increment = true;
                }
                HashSet<String> referrers = null;
                if (refer != null) {
                    ReferenceManager refManager = engine.getReferenceManager();
                    Iterator<String> iter = refManager.findCreated().iterator();
                    while (iter != null && iter.hasNext()) {
                        List<String> refs;
                        String name = iter.next();
                        boolean use = false;
                        int n = 0;
                        while (!use && n < refer.length) {
                            Matcher matcher = refer[n].matcher(name);
                            use = matcher.matches();
                            ++n;
                        }
                        if (!use || (refs = engine.getReferenceManager().findRefersTo(name)) == null || refs.isEmpty()) continue;
                        if (referrers == null) {
                            referrers = new HashSet<String>();
                        }
                        referrers.addAll(refs);
                    }
                }
                PageViewManager pageViewManager = this;
                synchronized (pageViewManager) {
                    Counter counter = this.m_counters.get(pagename);
                    if (increment && WikiContext.VIEW.equalsIgnoreCase(context.getRequestContext())) {
                        if (counter == null) {
                            counter = new Counter();
                            this.m_counters.put(pagename, counter);
                        }
                        counter.increment();
                        this.m_storage.setProperty(pagename, counter.toString());
                        this.m_dirty = true;
                    }
                    if (show != null && !PageViewPlugin.STR_NONE.equals(show)) {
                        if (PageViewPlugin.PARAM_COUNT.equals(show)) {
                            result = counter.toString();
                        } else if (body != null && body.length() > 0 && PageViewPlugin.STR_LIST.equals(show)) {
                            String header = PageViewPlugin.STR_EMPTY;
                            String line = body;
                            String footer = PageViewPlugin.STR_EMPTY;
                            int start = body.indexOf(PageViewPlugin.STR_SEPARATOR);
                            if (start > 0) {
                                int end;
                                header = body.substring(0, start);
                                if ((start = this.skipWhitespace(start + PageViewPlugin.STR_SEPARATOR.length(), body)) >= (end = body.indexOf(PageViewPlugin.STR_SEPARATOR, start))) {
                                    line = body.substring(start);
                                } else {
                                    line = body.substring(start, end);
                                    end = this.skipWhitespace(end + PageViewPlugin.STR_SEPARATOR.length(), body);
                                    footer = body.substring(end);
                                }
                            }
                            Map<String, Counter> sorted = this.m_counters;
                            if (sort != null && PageViewPlugin.PARAM_COUNT.equals(sort)) {
                                sorted = new TreeMap<Object, Counter>(this.m_compareCountDescending);
                                sorted.putAll(this.m_counters);
                            }
                            StringBuffer buf = new StringBuffer(header);
                            MessageFormat fmt = new MessageFormat(line);
                            Object[] args = new Object[]{pagename, PageViewPlugin.STR_EMPTY, PageViewPlugin.STR_EMPTY};
                            Iterator<Map.Entry<String, Counter>> iter = sorted.entrySet().iterator();
                            while (iter != null && entries > 0 && iter.hasNext()) {
                                Matcher matcher;
                                int n;
                                boolean use;
                                Map.Entry<String, Counter> entry = iter.next();
                                String name = entry.getKey();
                                int value = entry.getValue().getValue();
                                boolean bl = use = min <= value && value <= max;
                                if (use && referrers != null) {
                                    use = referrers.contains(name);
                                }
                                if (use && include != null) {
                                    use = false;
                                    n = 0;
                                    while (!use && n < include.length) {
                                        matcher = include[n].matcher(name);
                                        use = matcher.matches();
                                        ++n;
                                    }
                                }
                                if (use && exclude != null) {
                                    n = 0;
                                    while (use && n < exclude.length) {
                                        matcher = exclude[n].matcher(name);
                                        use &= !matcher.matches();
                                        ++n;
                                    }
                                }
                                if (!use) continue;
                                args[1] = engine.beautifyTitle(name);
                                args[2] = entry.getValue();
                                fmt.format(args, buf, (FieldPosition)null);
                                --entries;
                            }
                            buf.append(footer);
                            result = engine.textToHTML(context, buf.toString());
                        }
                    }
                }
            }
            return result;
        }

        private Pattern[] compileGlobs(String name, String value) throws PluginException {
            Pattern[] result = null;
            if (value != null && value.length() > 0 && !PageViewPlugin.STR_GLOBSTAR.equals(value)) {
                try {
                    String[] ptrns = StringUtils.split((String)value, (String)PageViewPlugin.STR_COMMA);
                    result = new Pattern[ptrns.length];
                    int n = 0;
                    while (n < ptrns.length) {
                        result[n] = Pattern.compile(RegExpUtil.globToPerl5(ptrns[n].toCharArray(), 0));
                        ++n;
                    }
                }
                catch (PatternSyntaxException e) {
                    throw new PluginException("Parameter " + name + " has a pattern syntax error: " + e.getMessage());
                }
            }
            return result;
        }

        private int skipWhitespace(int offset, String value) {
            while (Character.isWhitespace(value.charAt(offset))) {
                ++offset;
            }
            return offset;
        }

        protected int getCount(Object key) {
            return this.m_counters.get(key).getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadCounters() {
            if (this.m_counters != null && this.m_storage != null) {
                log.info("loadCounters", new Object[0]);
                PageViewManager pageViewManager = this;
                synchronized (pageViewManager) {
                    block19: {
                        InputStream fis = null;
                        try {
                            try {
                                fis = new FileInputStream(new File(this.m_workDir, PageViewPlugin.COUNTER_PAGE));
                                this.m_storage.load(fis);
                            }
                            catch (IOException ioe) {
                                log.error("loadCounters: Can't load page counter store: " + ioe.getMessage() + " , will create a new one", new Object[0]);
                                try {
                                    if (fis != null) {
                                        fis.close();
                                    }
                                    break block19;
                                }
                                catch (Exception exception) {}
                                break block19;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                if (fis != null) {
                                    fis.close();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                        try {
                            if (fis != null) {
                                fis.close();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    Iterator<Map.Entry<Object, Object>> iter = this.m_storage.entrySet().iterator();
                    while (iter != null && iter.hasNext()) {
                        Map.Entry<Object, Object> entry = iter.next();
                        this.m_counters.put((String)entry.getKey(), new Counter((String)entry.getValue()));
                    }
                    log.info("loadCounters: counters.size=" + this.m_counters.size(), new Object[0]);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void storeCounters() {
            if (this.m_counters != null && this.m_storage != null && this.m_dirty) {
                log.info("storeCounters: counters.size=" + this.m_counters.size(), new Object[0]);
                PageViewManager pageViewManager = this;
                synchronized (pageViewManager) {
                    block18: {
                        OutputStream fos = null;
                        try {
                            try {
                                fos = new FileOutputStream(new File(this.m_workDir, PageViewPlugin.COUNTER_PAGE));
                                this.m_storage.store(fos, "\n# The number of times each page has been viewed.\n# Do not modify.\n");
                                fos.flush();
                                this.m_dirty = false;
                            }
                            catch (IOException ioe) {
                                log.error("storeCounters: Can't store counters: " + ioe.getMessage(), new Object[0]);
                                try {
                                    if (fos != null) {
                                        fos.close();
                                    }
                                    break block18;
                                }
                                catch (Exception exception) {}
                                break block18;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                if (fos != null) {
                                    fos.close();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                        try {
                            if (fos != null) {
                                fos.close();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }
}

