/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.wiki.WikiContext;
import org.apache.wiki.api.PluginException;
import org.apache.wiki.content.ContentManager;
import org.apache.wiki.content.lock.PageLock;
import org.apache.wiki.plugin.WikiPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListLocksPlugin
implements WikiPlugin {
    @Override
    public String execute(WikiContext context, Map<String, Object> params) throws PluginException {
        StringBuilder result = new StringBuilder();
        ContentManager mgr = context.getEngine().getContentManager();
        List<PageLock> locks = mgr.getActiveLocks();
        ResourceBundle rb = context.getBundle("plugin.PluginResources");
        result.append("<table class=\"wikitable\">\n");
        result.append("<tr>\n");
        result.append("<th>" + rb.getString("plugin.listlocks.page") + "</th><th>" + rb.getString("plugin.listlocks.locked.by") + "</th><th>" + rb.getString("plugin.listlocks.acquired") + "</th><th>" + rb.getString("plugin.listlocks.expires") + "</th>\n");
        result.append("</tr>");
        if (locks.size() == 0) {
            result.append("<tr><td colspan=\"4\" class=\"odd\">" + rb.getString("plugin.listlocks.no.locks.exist") + "</td></tr>\n");
        } else {
            int rowNum = 1;
            for (PageLock lock : locks) {
                result.append(rowNum % 2 != 0 ? "<tr class=\"odd\">" : "<tr>");
                result.append("<td>" + lock.getPath().toString() + "</td>");
                result.append("<td>" + lock.getLocker() + "</td>");
                result.append("<td>" + lock.getAcquisitionTime() + "</td>");
                result.append("<td>" + lock.getExpiryTime() + "</td>");
                result.append("</tr>\n");
                ++rowNum;
            }
        }
        result.append("</table>");
        return result.toString();
    }
}

