/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.util.Collection;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiContext;
import org.apache.wiki.api.PluginException;
import org.apache.wiki.plugin.WikiPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterWikiLinksPlugin
implements WikiPlugin {
    private static Logger log = Logger.getLogger(InterWikiLinksPlugin.class);
    public static final String PARAM_TYPE = "type";
    public static final String PARAM_TABLE_TITLE = "tabletitle";
    public static final String PARAM_SEPARATOR = "separator";
    private OutputTypes m_defaultOutputType = OutputTypes.TEXT_OUTPUT;
    private String m_defaultTableTitle = "Interwiki Links Table";
    private String m_defaultSeparator = ", ";
    private String m_crlf = System.getProperty("line.separator");
    private Collection<String> m_links = null;

    @Override
    public String execute(WikiContext context, Map<String, Object> params) throws PluginException {
        ResourceBundle rb = context.getBundle("plugin.PluginResources");
        try {
            StringBuffer sb = new StringBuffer();
            OutputTypes outputType = this.m_defaultOutputType;
            this.m_links = context.getEngine().getAllInterWikiLinks();
            String typeParam = (String)params.get(PARAM_TYPE);
            String tableTitleParam = (String)params.get(PARAM_TABLE_TITLE);
            String separatorParam = (String)params.get(PARAM_SEPARATOR);
            if (typeParam == null) {
                outputType = OutputTypes.TEXT_OUTPUT;
            } else if ("TEXT".equals(typeParam.toUpperCase())) {
                outputType = OutputTypes.TEXT_OUTPUT;
            } else if ("ULIST".equals(typeParam.toUpperCase())) {
                outputType = OutputTypes.U_LIST_OUTPUT;
            } else if ("OLIST".equals(typeParam.toUpperCase())) {
                outputType = OutputTypes.O_LIST_OUTPUT;
            } else if ("TABLE".equals(typeParam.toUpperCase())) {
                outputType = OutputTypes.TABLE_OUTPUT;
            }
            if (tableTitleParam == null || "".equals(tableTitleParam)) {
                tableTitleParam = this.m_defaultTableTitle;
            }
            if (separatorParam == null || "".equals(separatorParam)) {
                separatorParam = this.m_defaultSeparator;
            }
            log.debug((Object)("TITLE: " + tableTitleParam + ", SEPARATOR: " + separatorParam + ", TYPE: " + outputType.name()));
            sb.append("<div class=\"interwikilinks\">" + this.m_crlf);
            if (outputType.equals((Object)OutputTypes.TEXT_OUTPUT)) {
                sb.append(String.valueOf(this.m_crlf) + "<span id=\"interwikilisttext\">");
                int linkCount = 0;
                for (String link : this.m_links) {
                    sb.append(link);
                    sb.append(" == ");
                    sb.append(context.getEngine().getInterWikiURL(link));
                    if (linkCount++ == this.m_links.size()) continue;
                    sb.append(separatorParam);
                }
                sb.append("</span>" + this.m_crlf);
            } else if (outputType.equals((Object)OutputTypes.U_LIST_OUTPUT)) {
                sb.append(this.generateListOutput(context, "<ul>", "</ul>"));
            } else if (outputType.equals((Object)OutputTypes.O_LIST_OUTPUT)) {
                sb.append(this.generateListOutput(context, "<ol>", "</ol>"));
            } else if (outputType.equals((Object)OutputTypes.TABLE_OUTPUT)) {
                sb.append("<table><caption>" + tableTitleParam + "</caption>" + this.m_crlf);
                sb.append("<tbody>" + this.m_crlf);
                for (String link : this.m_links) {
                    sb.append("<tr><td>");
                    sb.append(link);
                    sb.append("</td><td>");
                    sb.append(context.getEngine().getInterWikiURL(link));
                    sb.append("</td></tr>" + this.m_crlf);
                }
                sb.append("</tbody>" + this.m_crlf);
                sb.append("</table>" + this.m_crlf);
            }
            sb.append(String.valueOf(this.m_crlf) + "</div>" + this.m_crlf);
            return sb.toString();
        }
        catch (Exception e) {
            log.error((Object)"Could not construct InterwikiLinks plugin output, reason: ", (Throwable)e);
            throw new PluginException(rb.getString("plugin.interwikilinks.noconstruct"));
        }
    }

    private StringBuffer generateListOutput(WikiContext context, String startTag, String endTag) {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(startTag) + this.m_crlf);
        for (String link : this.m_links) {
            sb.append("    <li>");
            sb.append(link);
            sb.append(" == ");
            sb.append(context.getEngine().getInterWikiURL(link));
            sb.append("    </li>" + this.m_crlf);
        }
        return sb.append(String.valueOf(endTag) + this.m_crlf);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum OutputTypes {
        TEXT_OUTPUT,
        U_LIST_OUTPUT,
        O_LIST_OUTPUT,
        TABLE_OUTPUT;

    }
}

