/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.util.ArrayList;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.PluginException;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.auth.AuthorizationManager;
import org.apache.wiki.auth.permissions.PermissionFactory;
import org.apache.wiki.content.WikiPath;
import org.apache.wiki.plugin.WikiPlugin;
import org.apache.wiki.providers.ProviderException;
import org.apache.wiki.util.TextUtil;

public class InsertPage
implements WikiPlugin {
    public static final String PARAM_PAGENAME = "page";
    public static final String PARAM_STYLE = "style";
    public static final String PARAM_MAXLENGTH = "maxlength";
    public static final String PARAM_CLASS = "class";
    public static final String PARAM_SECTION = "section";
    public static final String PARAM_DEFAULT = "default";
    private static final String DEFAULT_STYLE = "";
    public static final String ATTR_RECURSE = "org.apache.wiki.plugin.InsertPage.recurseCheck";

    public String execute(WikiContext context, Map params) throws PluginException {
        WikiEngine engine = context.getEngine();
        ResourceBundle rb = context.getBundle("plugin.PluginResources");
        StringBuilder res = new StringBuilder();
        String clazz = (String)params.get(PARAM_CLASS);
        String includedPage = (String)params.get(PARAM_PAGENAME);
        String style = (String)params.get(PARAM_STYLE);
        String defaultstr = (String)params.get(PARAM_DEFAULT);
        int section = TextUtil.parseIntParameter((String)params.get(PARAM_SECTION), -1);
        int maxlen = TextUtil.parseIntParameter((String)params.get(PARAM_MAXLENGTH), -1);
        if (style == null) {
            style = DEFAULT_STYLE;
        }
        if (maxlen == -1) {
            maxlen = Integer.MAX_VALUE;
        }
        if (includedPage != null) {
            WikiPage page = null;
            try {
                WikiPath pageName = engine.getFinalPageName(context.getPage().getPath().resolve(includedPage));
                if (pageName == null) {
                    String includedPageNoSpaces = includedPage.replace(" ", DEFAULT_STYLE);
                    pageName = engine.getFinalPageName(context.getPage().getPath().resolve(includedPageNoSpaces));
                }
                page = pageName != null ? engine.getPage(pageName) : engine.getPage(includedPage);
            }
            catch (Exception e) {
                res.append("<span class=\"error\">" + rb.getString("plugin.insert.notfound") + "</span>");
                return res.toString();
            }
            if (page != null) {
                String pageData;
                ArrayList<String> previousIncludes = (ArrayList<String>)context.getVariable(ATTR_RECURSE);
                if (previousIncludes != null) {
                    if (previousIncludes.contains(page.getName())) {
                        return "<span class=\"error\">" + rb.getString("plugin.insert.recursion") + "</span>";
                    }
                } else {
                    previousIncludes = new ArrayList<String>();
                }
                previousIncludes.add(page.getName());
                context.setVariable(ATTR_RECURSE, previousIncludes);
                AuthorizationManager mgr = engine.getAuthorizationManager();
                if (!mgr.checkPermission(context.getWikiSession(), PermissionFactory.getPagePermission(page, "view"))) {
                    res.append("<span class=\"error\">" + rb.getString("plugin.insert.nopermission") + "</span>");
                    return res.toString();
                }
                WikiContext includedContext = (WikiContext)context.clone();
                includedContext.setPage(page);
                try {
                    pageData = page.getContentAsString();
                }
                catch (ProviderException e) {
                    pageData = DEFAULT_STYLE;
                }
                String moreLink = DEFAULT_STYLE;
                if (section != -1) {
                    try {
                        pageData = TextUtil.getSection(pageData, section);
                    }
                    catch (IllegalArgumentException e) {
                        throw new PluginException(e.getMessage());
                    }
                }
                if (pageData.length() > maxlen) {
                    pageData = String.valueOf(pageData.substring(0, maxlen)) + " ...";
                    moreLink = "<p><a href=\"" + context.getURL(WikiContext.VIEW, includedPage) + "\">More...</a></p>";
                }
                res.append("<div style=\"" + style + "\"" + (clazz != null ? " class=\"" + clazz + "\"" : DEFAULT_STYLE) + ">");
                res.append(engine.textToHTML(includedContext, pageData));
                res.append(moreLink);
                res.append("</div>");
                previousIncludes.remove(page.getName());
                context.setVariable(ATTR_RECURSE, previousIncludes);
            } else if (defaultstr != null) {
                res.append(defaultstr);
            } else {
                res.append(String.valueOf(rb.getString("plugin.insert.nopage1")) + " '" + includedPage + "'.  " + rb.getString("plugin.insert.nopage2"));
                res.append("<a href=\"" + context.getURL("edit", includedPage) + "\"> " + rb.getString("plugin.insert.nopage3") + "</a>");
            }
        } else {
            res.append("<span class=\"error\">");
            res.append(rb.getString("plugin.insert.definepage"));
            res.append("</span>");
        }
        return res.toString();
    }
}

