/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.span;
import org.apache.wiki.WikiContext;
import org.apache.wiki.api.PluginException;
import org.apache.wiki.api.WikiPage;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.plugin.AbstractFilteredPlugin;
import org.apache.wiki.plugin.WikiPlugin;
import org.apache.wiki.providers.ProviderException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexPlugin
extends AbstractFilteredPlugin
implements WikiPlugin {
    private static Logger log = LoggerFactory.getLogger(IndexPlugin.class);

    @Override
    public String execute(WikiContext context, Map<String, Object> params) throws PluginException {
        super.initialize(context, params);
        div masterDiv = new div();
        masterDiv.setClass("index");
        div indexDiv = new div();
        masterDiv.addElement((Element)indexDiv);
        indexDiv.setClass("header");
        try {
            List<WikiPage> pages = context.getEngine().getContentManager().getAllPages(null);
            pages = super.filterCollection(pages);
            Collections.sort(pages);
            char initialChar = ' ';
            div currentDiv = new div();
            for (WikiPage page : pages) {
                String name = page.getName();
                if (name.charAt(0) != initialChar) {
                    if (initialChar != ' ') {
                        indexDiv.addElement(" - ");
                    }
                    initialChar = name.charAt(0);
                    masterDiv.addElement(this.makeHeader(initialChar));
                    currentDiv = new div();
                    currentDiv.setClass("body");
                    masterDiv.addElement((Element)currentDiv);
                    indexDiv.addElement("<a href='#" + initialChar + "'>" + initialChar + "</a>");
                } else {
                    currentDiv.addElement(", ");
                }
                String link = "<a href='" + context.getURL(WikiContext.VIEW, name) + "'>" + name + "</a>";
                currentDiv.addElement(link);
            }
        }
        catch (ProviderException e) {
            log.warn("Could not load page index", e, new Object[0]);
            throw new PluginException(e.getMessage());
        }
        return masterDiv.toString();
    }

    private Element makeHeader(char initialChar) {
        span s = new span();
        s.setClass("section");
        s.addElement("<a name='" + initialChar + "'>" + initialChar + "</a>");
        return s;
    }
}

