/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.util.Map;
import java.util.ResourceBundle;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.PluginException;
import org.apache.wiki.attachment.Attachment;
import org.apache.wiki.attachment.AttachmentManager;
import org.apache.wiki.plugin.WikiPlugin;
import org.apache.wiki.util.TextUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Image
implements WikiPlugin {
    public static final String PARAM_SRC = "src";
    public static final String PARAM_ALIGN = "align";
    public static final String PARAM_HEIGHT = "height";
    public static final String PARAM_WIDTH = "width";
    public static final String PARAM_ALT = "alt";
    public static final String PARAM_CAPTION = "caption";
    public static final String PARAM_LINK = "link";
    public static final String PARAM_TARGET = "target";
    public static final String PARAM_STYLE = "style";
    public static final String PARAM_CLASS = "class";
    public static final String PARAM_BORDER = "border";

    private static final String getCleanParameter(Map<String, Object> params, String paramId) {
        return TextUtil.replaceEntities((String)params.get(paramId));
    }

    @Override
    public String execute(WikiContext context, Map<String, Object> params) throws PluginException {
        ResourceBundle rb = context.getBundle("plugin.PluginResources");
        WikiEngine engine = context.getEngine();
        String src = Image.getCleanParameter(params, PARAM_SRC);
        String align = Image.getCleanParameter(params, PARAM_ALIGN);
        String ht = Image.getCleanParameter(params, PARAM_HEIGHT);
        String wt = Image.getCleanParameter(params, PARAM_WIDTH);
        String alt = Image.getCleanParameter(params, PARAM_ALT);
        String caption = Image.getCleanParameter(params, PARAM_CAPTION);
        String link = Image.getCleanParameter(params, PARAM_LINK);
        String target = Image.getCleanParameter(params, PARAM_TARGET);
        String style = Image.getCleanParameter(params, PARAM_STYLE);
        String cssclass = Image.getCleanParameter(params, PARAM_CLASS);
        String border = Image.getCleanParameter(params, PARAM_BORDER);
        if (src == null) {
            throw new PluginException(String.valueOf(rb.getString(" plugin.image.parmsrc.req.1")) + " 'src' " + rb.getString(" plugin.image.parmsrc.req.2"));
        }
        if (cssclass == null) {
            cssclass = "imageplugin";
        }
        if (target != null && !this.validTargetValue(target)) {
            target = null;
        }
        try {
            AttachmentManager mgr = engine.getAttachmentManager();
            Attachment att = mgr.getAttachmentInfo(context, src);
            if (att != null) {
                src = context.getURL(WikiContext.ATTACH, att.getName());
            }
        }
        catch (Exception e) {
            throw new PluginException(String.valueOf(rb.getString("plugin.image.attachinfo.failed")) + e.getMessage());
        }
        StringBuilder result = new StringBuilder();
        result.append("<table border=\"0\" class=\"" + cssclass + "\"");
        if (style != null) {
            result.append(" style=\"" + style);
            if (result.charAt(result.length() - 1) != ';') {
                result.append(";");
            }
            if (align != null && align.equals("center")) {
                result.append(" margin-left: auto; margin-right: auto;");
            }
            result.append("\"");
        } else if (align != null && align.equals("center")) {
            result.append(" style=\"margin-left: auto; margin-right: auto;\"");
        }
        if (align != null && !align.equals("center")) {
            result.append(" align=\"" + align + "\"");
        }
        result.append(">\n");
        if (caption != null) {
            result.append("<caption align=bottom>" + TextUtil.replaceEntities(caption) + "</caption>\n");
        }
        result.append("<tr><td>");
        if (link != null) {
            result.append("<a href=\"" + link + "\"");
            if (target != null) {
                result.append(" target=\"" + target + "\"");
            }
            result.append(">");
        }
        result.append("<img src=\"" + src + "\"");
        if (ht != null) {
            result.append(" height=\"" + ht + "\"");
        }
        if (wt != null) {
            result.append(" width=\"" + wt + "\"");
        }
        if (alt != null) {
            result.append(" alt=\"" + alt + "\"");
        }
        if (border != null) {
            result.append(" border=\"" + border + "\"");
        }
        result.append(" />");
        if (link != null) {
            result.append("</a>");
        }
        result.append("</td></tr>\n");
        result.append("</table>\n");
        return result.toString();
    }

    private boolean validTargetValue(String s) {
        if (s.equals("_blank") || s.equals("_self") || s.equals("_parent") || s.equals("_top")) {
            return true;
        }
        if (s.length() > 0) {
            char c = s.charAt(0);
            return Character.isLowerCase(c) || Character.isUpperCase(c);
        }
        return false;
    }
}

