/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.security.Principal;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;
import org.apache.wiki.WikiContext;
import org.apache.wiki.api.ModuleData;
import org.apache.wiki.api.PluginException;
import org.apache.wiki.plugin.WikiPlugin;
import org.apache.wiki.util.TextUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ModuleData(aliases={"If"})
public class IfPlugin
implements WikiPlugin {
    public static final String PARAM_GROUP = "group";
    public static final String PARAM_USER = "user";
    public static final String PARAM_IP = "ip";
    public static final String PARAM_PAGE = "page";
    public static final String PARAM_CONTAINS = "contains";
    public static final String PARAM_VAR = "var";
    public static final String PARAM_IS = "is";
    public static final String PARAM_EXISTS = "exists";

    @Override
    public String execute(WikiContext context, Map<String, Object> params) throws PluginException {
        return IfPlugin.ifInclude(context, params) ? context.getEngine().textToHTML(context, (String)params.get("_body")) : "";
    }

    public static boolean ifInclude(WikiContext context, Map<String, Object> params) throws PluginException {
        String content;
        boolean include = false;
        String group = (String)params.get(PARAM_GROUP);
        String user = (String)params.get(PARAM_USER);
        String ip = (String)params.get(PARAM_IP);
        String page = (String)params.get(PARAM_PAGE);
        String contains = (String)params.get(PARAM_CONTAINS);
        String var = (String)params.get(PARAM_VAR);
        String is = (String)params.get(PARAM_IS);
        String exists = (String)params.get(PARAM_EXISTS);
        include |= IfPlugin.checkGroup(context, group);
        include |= IfPlugin.checkUser(context, user);
        include |= IfPlugin.checkIP(context, ip);
        if (page != null) {
            content = context.getEngine().getPureText(page, -1).trim();
            include |= IfPlugin.checkContains(content, contains, context);
            include |= IfPlugin.checkIs(content, is, context);
            include |= IfPlugin.checkExists(context, page, exists);
        }
        if (var != null) {
            content = context.getEngine().getVariable(context, var);
            include |= IfPlugin.checkContains(content, contains, context);
            include |= IfPlugin.checkIs(content, is, context);
            include |= IfPlugin.checkVarExists(content, exists);
        }
        return include;
    }

    private static boolean checkExists(WikiContext context, String page, String exists) {
        if (exists == null) {
            return false;
        }
        return !context.getEngine().pageExists(page) ^ TextUtil.isPositive(exists);
    }

    private static boolean checkVarExists(String varContent, String exists) {
        if (exists == null) {
            return false;
        }
        return varContent == null ^ TextUtil.isPositive(exists);
    }

    private static boolean checkGroup(WikiContext context, String group) {
        if (group == null) {
            return false;
        }
        String[] groupList = StringUtils.split((String)group, (char)'|');
        boolean include = false;
        int i = 0;
        while (i < groupList.length) {
            String gname = groupList[i];
            boolean invert = false;
            if (groupList[i].startsWith("!")) {
                gname = groupList[i].substring(1);
                invert = true;
            }
            Principal g = context.getEngine().getAuthorizationManager().resolvePrincipal(gname);
            include |= context.getEngine().getAuthorizationManager().isUserInRole(context.getWikiSession(), g) ^ invert;
            ++i;
        }
        return include;
    }

    private static boolean checkUser(WikiContext context, String user) {
        if (user == null || context.getCurrentUser() == null) {
            return false;
        }
        String[] list = StringUtils.split((String)user, (char)'|');
        boolean include = false;
        int i = 0;
        while (i < list.length) {
            boolean invert = false;
            if (list[i].startsWith("!")) {
                invert = true;
            }
            include |= user.equals(context.getCurrentUser().getName()) ^ invert;
            ++i;
        }
        return include;
    }

    private static boolean checkIP(WikiContext context, String ipaddr) {
        if (ipaddr == null || context.getHttpRequest() == null) {
            return false;
        }
        String[] list = StringUtils.split((String)ipaddr, (char)'|');
        boolean include = false;
        int i = 0;
        while (i < list.length) {
            boolean invert = false;
            if (list[i].startsWith("!")) {
                invert = true;
            }
            include |= ipaddr.equals(context.getHttpRequest().getRemoteAddr()) ^ invert;
            ++i;
        }
        return include;
    }

    private static boolean doMatch(String content, String pattern, WikiContext context) throws PluginException {
        try {
            Pattern matchPattern = Pattern.compile(pattern);
            return matchPattern.matcher(content).matches();
        }
        catch (PatternSyntaxException e) {
            throw new PluginException(String.valueOf(context.getBundle("plugin.PluginResources").getString("plugin.if.faulty.pattern")) + pattern);
        }
    }

    private static boolean checkContains(String pagecontent, String matchPattern, WikiContext context) throws PluginException {
        if (pagecontent == null || matchPattern == null) {
            return false;
        }
        return IfPlugin.doMatch(pagecontent, ".*" + matchPattern + ".*", context);
    }

    private static boolean checkIs(String content, String matchPattern, WikiContext context) throws PluginException {
        if (content == null || matchPattern == null) {
            return false;
        }
        matchPattern = "^" + matchPattern + "$";
        return IfPlugin.doMatch(content, matchPattern, context);
    }
}

