/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.security.Principal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.PluginException;
import org.apache.wiki.auth.PrincipalComparator;
import org.apache.wiki.auth.authorize.GroupManager;
import org.apache.wiki.plugin.WikiPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Groups
implements WikiPlugin {
    private static final Comparator<Principal> COMPARATOR = new PrincipalComparator();

    @Override
    public String execute(WikiContext context, Map<String, Object> params) throws PluginException {
        WikiEngine engine = context.getEngine();
        GroupManager groupMgr = engine.getGroupManager();
        Principal[] groups = groupMgr.getRoles();
        Arrays.sort(groups, COMPARATOR);
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < groups.length) {
            String name = groups[i].getName();
            String url = engine.getURLConstructor().makeURL(WikiContext.VIEW_GROUP, name, false, null);
            s.append("<a href=\"");
            s.append(url);
            s.append("\">");
            s.append(name);
            s.append("</a>");
            if (i < groups.length - 1) {
                s.append(',');
                s.append(' ');
            }
            ++i;
        }
        return s.toString();
    }
}

