/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.apache.wiki.WikiContext;
import org.apache.wiki.api.PluginException;
import org.apache.wiki.log.Logger;
import org.apache.wiki.log.LoggerFactory;
import org.apache.wiki.plugin.WikiPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Denounce
implements WikiPlugin {
    private static Logger log = LoggerFactory.getLogger(Denounce.class);
    public static final String PARAM_LINK = "link";
    public static final String PARAM_TEXT = "text";
    private static final String PROPERTYFILE = "DenouncePlugin.properties";
    private static final String PROP_AGENTPATTERN = "denounce.agentpattern.";
    private static final String PROP_HOSTPATTERN = "denounce.hostpattern.";
    private static final String PROP_REFERERPATTERN = "denounce.refererpattern.";
    private static ArrayList<Pattern> c_refererPatterns = new ArrayList();
    private static ArrayList<Pattern> c_agentPatterns = new ArrayList();
    private static ArrayList<Pattern> c_hostPatterns = new ArrayList();
    private static String c_denounceText = "";

    static {
        try {
            ClassLoader loader = Denounce.class.getClassLoader();
            InputStream in = loader.getResourceAsStream(PROPERTYFILE);
            if (in == null) {
                throw new IOException("No property file found! (Check the installation, it should be there.)");
            }
            Properties props = new Properties();
            props.load(in);
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                try {
                    if (name.startsWith(PROP_REFERERPATTERN)) {
                        c_refererPatterns.add(Pattern.compile(props.getProperty(name)));
                        continue;
                    }
                    if (name.startsWith(PROP_AGENTPATTERN)) {
                        c_agentPatterns.add(Pattern.compile(props.getProperty(name)));
                        continue;
                    }
                    if (!name.startsWith(PROP_HOSTPATTERN)) continue;
                    c_hostPatterns.add(Pattern.compile(props.getProperty(name)));
                }
                catch (PatternSyntaxException ex) {
                    log.error("Malformed URL pattern in DenouncePlugin.properties: " + props.getProperty(name), ex);
                }
            }
            log.debug("Added " + c_refererPatterns.size() + c_agentPatterns.size() + c_hostPatterns.size() + " crawlers to denounce list.", new Object[0]);
        }
        catch (IOException e) {
            log.error("Unable to load URL patterns from DenouncePlugin.properties", e);
        }
        catch (Exception e) {
            log.error("Unable to initialize Denounce plugin", e);
        }
    }

    @Override
    public String execute(WikiContext context, Map<String, Object> params) throws PluginException {
        c_denounceText = context.getBundle("plugin.PluginResources").getString("plugin.denounce.denouncetext");
        String link = (String)params.get(PARAM_LINK);
        String text = (String)params.get(PARAM_TEXT);
        boolean linkAllowed = true;
        if (link == null) {
            throw new PluginException(String.valueOf(context.getBundle("plugin.PluginResources").getString("plugin.denounce.no.parameter")) + PARAM_LINK);
        }
        HttpServletRequest request = context.getHttpRequest();
        if (request != null) {
            boolean bl = linkAllowed = !this.matchHeaders(request);
        }
        if (text == null) {
            text = link;
        }
        if (linkAllowed) {
            return "<a href=\"" + link + "\">" + text + "</a>";
        }
        return c_denounceText;
    }

    private boolean matchPattern(List<Pattern> list, String path) {
        for (Pattern pattern : list) {
            if (!pattern.matcher(path).find()) continue;
            return true;
        }
        return false;
    }

    private boolean matchHeaders(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        if (userAgent != null && this.matchPattern(c_agentPatterns, userAgent)) {
            log.debug("Matched user agent " + userAgent + " for denounce.", new Object[0]);
            return true;
        }
        String refererPath = request.getHeader("Referer");
        if (refererPath != null && this.matchPattern(c_refererPatterns, refererPath)) {
            log.debug("Matched referer " + refererPath + " for denounce.", new Object[0]);
            return true;
        }
        String host = request.getRemoteHost();
        if (host != null && this.matchPattern(c_hostPatterns, host)) {
            log.debug("Matched host " + host + " for denounce.", new Object[0]);
            return true;
        }
        return false;
    }
}

